/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.jobs;

import com.moonlit.logfaces.client.jobs.Importer;
import com.moonlit.logfaces.client.net.LfsConnector;
import com.moonlit.logfaces.client.utils.Utils;
import com.moonlit.logfaces.server.decoders.Log4jXmlDecoder;
import com.moonlit.logfaces.server.remoting.LfsRemote;
import com.moonlit.logfaces.server.vo.LoggingEventVO;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.IProgressMonitor;

public class XmlImporter
implements Importer {
    private File file;
    private String domain;
    private Throwable lastError;
    private long imported = 0L;
    private long failed = 0L;

    public XmlImporter(File file, String domain) {
        this.file = file;
        this.domain = domain;
    }

    @Override
    public long getImported() {
        return this.imported;
    }

    @Override
    public long getFailed() {
        return this.failed;
    }

    @Override
    public Throwable getLastError() {
        return this.lastError;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        block12: {
            monitor.beginTask("Importing xml data..", 100);
            ArrayList<LoggingEventVO> list = new ArrayList<LoggingEventVO>();
            BufferedReader reader = null;
            try {
                try {
                    reader = new BufferedReader(new FileReader(this.file));
                    LfsRemote lfs = LfsConnector.getInstance().getConnection();
                    String sid = LfsConnector.getInstance().getSid();
                    long start = System.currentTimeMillis();
                    Log4jXmlDecoder decoder = new Log4jXmlDecoder();
                    String line = null;
                    StringBuffer buffer = new StringBuffer();
                    while ((line = reader.readLine()) != null && !monitor.isCanceled()) {
                        List decoded;
                        if (!line.startsWith("<log4j:event ")) continue;
                        buffer.delete(0, buffer.length());
                        buffer.append(line);
                        while ((line = reader.readLine()) != null) {
                            buffer.append(line);
                            if (line.startsWith("</log4j:event>")) break;
                        }
                        if ((decoded = decoder.decode(buffer.toString())).isEmpty()) {
                            ++this.failed;
                            continue;
                        }
                        LoggingEventVO vo = (LoggingEventVO)decoded.get(0);
                        if (this.domain != null) {
                            vo.getProperties().put("application", this.domain);
                        }
                        if (vo.isThrown()) {
                            this.fixException(vo);
                        }
                        list.add(vo);
                        if (list.size() <= 100) continue;
                        lfs.importData(sid, list);
                        this.imported += (long)list.size();
                        list.clear();
                        monitor.subTask("imported: " + this.imported + " records, avg. speed: " + this.imported * 1000L / (System.currentTimeMillis() - start) + " rec/sec");
                        monitor.worked((int)this.imported);
                    }
                    if (list.size() > 0) {
                        lfs.importData(sid, list);
                        this.imported += (long)list.size();
                        list.clear();
                        monitor.subTask("imported so far: " + this.imported + " records");
                        monitor.worked((int)this.imported);
                    }
                }
                catch (Throwable e) {
                    this.lastError = e;
                    Throwable cause = e.getCause();
                    if (cause != null) {
                        this.lastError = cause;
                    }
                    IOUtils.closeQuietly((Reader)reader);
                    break block12;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    void fixException(LoggingEventVO vo) {
        if (vo.getThrowableInfo() == null) {
            return;
        }
        String[] split = vo.getThrowableInfo().split("\t");
        StringBuffer buffer = new StringBuffer();
        String[] stringArray = split;
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            buffer.append(line);
            buffer.append(Utils.LINE_SEPARATOR);
            buffer.append("\t");
            ++n2;
        }
        vo.setThrowableInfo(buffer.toString());
    }
}

