/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.jobs;

import com.moonlit.logfaces.client.dashboard.Widget;
import com.moonlit.logfaces.client.net.LfsConnector;
import com.moonlit.logfaces.server.remoting.LfsRemote;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class WidgetJob
extends Job {
    private Widget widget;
    private static Logger log = LogManager.getLogger(WidgetJob.class);

    public WidgetJob(Widget widget) {
        super(String.format("Getting data for '%s' widget", widget.getName()));
        this.widget = widget;
    }

    public IStatus run(IProgressMonitor monitor) {
        try {
            LfsConnector connector = LfsConnector.getInstance();
            LfsRemote connection = connector.getConnection();
            if (connection == null) {
                return Status.CANCEL_STATUS;
            }
            String sid = connector.getSid();
            Map<String, Object> params = this.widget.buildQuery();
            long fromTime = (Long)params.get("fromTime");
            long toTime = (Long)params.get("toTime");
            List stats = connection.queryDistribution(sid, params);
            this.widget.getModel().setData(stats, fromTime, toTime, true);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            this.widget.getModel().setData(null, 0L, 0L, false);
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }
}

