/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.jobs;

import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.model.QueryModel;
import com.moonlit.logfaces.client.model.QueryVO;
import com.moonlit.logfaces.client.net.LfsConnector;
import com.moonlit.logfaces.client.utils.Compatibility;
import com.moonlit.logfaces.client.utils.Utils;
import com.moonlit.logfaces.server.remoting.LfsRemote;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class UpdatePinJob
extends Job {
    private IProgressMonitor monitor;
    private QueryVO query;
    private static Logger log = LogManager.getLogger(UpdatePinJob.class);

    public static void run(QueryVO query) {
        UpdatePinJob job = new UpdatePinJob(query);
        job.setUser(false);
        job.schedule();
    }

    public UpdatePinJob(QueryVO query) {
        super("Updaing pin");
        this.query = query;
    }

    protected void canceling() {
        if (this.monitor != null) {
            this.monitor.setCanceled(true);
        }
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.monitor = monitor;
        LfsRemote connection = LfsConnector.getInstance().getConnection();
        if (connection == null) {
            return Status.OK_STATUS;
        }
        if (!Compatibility.canUsePins() || Application.isServerMode()) {
            return Status.OK_STATUS;
        }
        try {
            String sid = LfsConnector.getInstance().getSid();
            if (QueryModel.getInstance().getQuery(this.query.getName()) == null) {
                connection.removePin(sid, this.query.getPinID());
            } else {
                connection.addPin(sid, this.query.getPinID(), this.query.toXml());
            }
            log.info("updated {} pin", (Object)this.query.getName());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Utils.displayPopup("Failed to get repository data", e.getMessage(), true);
        }
        return Status.OK_STATUS;
    }
}

