/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.jobs;

import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.utils.P2Utils;
import com.moonlit.logfaces.client.utils.Utils;
import java.lang.reflect.InvocationTargetException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;

public class UpdateJob
extends Job {
    private IProvisioningAgent agent;
    private IStatus result;
    private static Logger log = LogManager.getLogger(UpdateJob.class);

    public UpdateJob(IProvisioningAgent agent) {
        super("Checking for updates");
        this.agent = agent;
    }

    protected IStatus run(IProgressMonitor monitor) {
        log.info("software update job starts");
        String site = Application.getPrefs().get("lfs_updates_url", "https://www.moonlit-software.com/logfaces/updates");
        P2Utils.clearCache(this.agent, monitor);
        if (!P2Utils.addRepository(this.agent, site)) {
            Utils.displayPopup("Update repository", "Update repository is not reachable", true);
            return Status.CANCEL_STATUS;
        }
        this.result = P2Utils.checkForUpdates(this.agent, monitor);
        if (this.result.getCode() == 10000) {
            Utils.displayPopup("No updates", "Your software is up to date", false);
            return this.result;
        }
        this.installUpdates();
        return this.result;
    }

    private void installUpdates() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!MessageDialog.openQuestion((Shell)Application.getShell(), (String)"Updates available", (String)"There are updates available, would you like to download and install now?\nThe application will restart after installation.")) {
                    log.info("downloading update canceled by user");
                    return;
                }
                log.info("downloading software update package");
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(Display.getDefault().getActiveShell());
                try {
                    dialog.run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            (this).UpdateJob.this.result = P2Utils.installUpdates((this).UpdateJob.this.agent, monitor);
                            if (!(this).UpdateJob.this.result.isOK()) {
                                StatusManager.getManager().handle((this).UpdateJob.this.result, 1);
                                Utils.displayPopup("Update failed", String.format("Unable to download or install this update, error: %d", (this).UpdateJob.this.result.getCode()), true);
                                return;
                            }
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    log.info("restarting workbench");
                                    PlatformUI.getWorkbench().restart();
                                }
                            });
                        }
                    });
                }
                catch (Exception e) {
                    UpdateJob.this.result = new Status(4, "com.moonlit.logfaces.client.plugin", "Update failed", (Throwable)e);
                    StatusManager.getManager().handle(UpdateJob.this.result);
                }
            }
        });
    }
}

