/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.jobs;

import com.moonlit.logfaces.client.jobs.Saver;
import com.moonlit.logfaces.client.model.QueryVO;
import com.moonlit.logfaces.client.net.LfsConnector;
import com.moonlit.logfaces.client.types.FileFormat;
import com.moonlit.logfaces.client.utils.Utils;
import com.moonlit.logfaces.server.core.ReceiverType;
import com.moonlit.logfaces.server.remoting.LfsRemote;
import com.moonlit.logfaces.server.util.LogFile;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class TextQuerySaver
implements Saver {
    private Throwable error;
    private long nofFetched = 0L;
    private QueryVO query;
    private String fileName;
    private FileFormat format;

    public TextQuerySaver(QueryVO query, String fileName, FileFormat format) {
        this.query = query;
        this.fileName = fileName;
        this.format = format;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run(IProgressMonitor monitor) throws InvocationTargetException {
        LfsRemote lfs = LfsConnector.getInstance().getConnection();
        LogFile logFile = Utils.makeLogFile(ReceiverType.log4j, this.fileName);
        String sid = LfsConnector.getInstance().getSid();
        String qid = "" + System.currentTimeMillis();
        monitor.beginTask("Retrieving data..", this.query.getLimit());
        try {
            long start = System.currentTimeMillis();
            List results = lfs.queryBegin(sid, qid, this.query.toMap(), 500, -1);
            if (results == null) {
                monitor.setCanceled(true);
                return;
            }
            try {
                logFile.initialize();
                do {
                    logFile.write((Collection)results);
                    this.nofFetched += (long)results.size();
                    monitor.subTask("fetched: " + this.nofFetched + " records, avg. speed: " + this.nofFetched * 1000L / (System.currentTimeMillis() - start) + " rec/sec");
                    monitor.worked(results.size());
                    results = lfs.queryNext(sid, qid);
                    if (monitor.isCanceled()) return;
                } while (results != null);
                return;
            }
            catch (Exception ex) {
                this.error = ex;
                monitor.setCanceled(true);
            }
            return;
        }
        finally {
            try {
                logFile.terminate();
                lfs.queryEnd(sid, qid);
            }
            catch (Exception e) {
                this.error = e;
                monitor.setCanceled(true);
            }
        }
    }

    @Override
    public Throwable getError() {
        return this.error;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public FileFormat getFormat() {
        return this.format;
    }

    @Override
    public String getName() {
        return this.query.getName();
    }

    @Override
    public long getNofFetched() {
        return this.nofFetched;
    }
}

