/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.jobs;

import com.google.common.collect.Lists;
import com.moonlit.logfaces.client.model.PluginsDelegate;
import com.moonlit.logfaces.client.net.LfsConnector;
import com.moonlit.logfaces.client.utils.Utils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;

public class SyncPluginsJob
extends Job {
    private List<String> names;
    private Runnable callback;
    private PluginsDelegate plugins = PluginsDelegate.getInstance();
    private static Logger log = LogManager.getLogger(SyncPluginsJob.class);

    public SyncPluginsJob() {
        super("Syncronize plugins");
        this.names = this.plugins.getWorkspacePluginNames();
    }

    public SyncPluginsJob(List<String> names) {
        super("Syncronize plugins");
        this.names = names != null ? Lists.newArrayList(names) : Lists.newArrayList();
    }

    public SyncPluginsJob(List<String> names, Runnable callback) {
        super("Syncronize plugins");
        this.names = names != null ? Lists.newArrayList(names) : Lists.newArrayList();
        this.callback = callback;
    }

    public SyncPluginsJob(Runnable callback) {
        super("Syncronize plugins");
        this.names = this.plugins.getWorkspacePluginNames();
        this.callback = callback;
    }

    protected IStatus run(IProgressMonitor monitor) {
        block11: {
            File tempFile = null;
            if (!this.names.isEmpty()) {
                try {
                    try {
                        List list;
                        LfsConnector connector = LfsConnector.getInstance();
                        if (connector.isConnected() && !(list = connector.getConnection().listPlugins(connector.getSid())).isEmpty()) {
                            InputStream is = connector.getConnection().downloadPlugins(connector.getSid(), this.names);
                            tempFile = File.createTempFile("lfs-", "-plugins");
                            tempFile.deleteOnExit();
                            IOUtils.copy((InputStream)is, (OutputStream)new FileOutputStream(tempFile));
                            int imported = PluginsDelegate.getInstance().importPlugins(tempFile);
                            log.info(String.format("imported %d plugins from server", imported));
                        }
                    }
                    catch (Exception ex) {
                        log.error(ex.getMessage(), (Throwable)ex);
                        Utils.displayException("SyncPluginsJob", "Unable to syncronize plugins", ex.getCause() != null ? ex.getCause() : ex);
                        if (tempFile != null) {
                            FileUtils.deleteQuietly(tempFile);
                        }
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    if (tempFile != null) {
                        FileUtils.deleteQuietly(tempFile);
                    }
                    throw throwable;
                }
                if (tempFile != null) {
                    FileUtils.deleteQuietly(tempFile);
                }
            }
        }
        if (this.callback != null) {
            Display.getDefault().asyncExec(this.callback);
        }
        return Status.OK_STATUS;
    }
}

