/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.jobs;

import com.moonlit.logfaces.client.jobs.Fetcher;
import com.moonlit.logfaces.client.model.QueryVO;
import com.moonlit.logfaces.client.model.data.Log4jModel;
import com.moonlit.logfaces.client.model.data.LogDataModel;
import com.moonlit.logfaces.client.types.TimeRange;
import com.moonlit.logfaces.client.utils.Utils;
import com.moonlit.logfaces.server.core.LogEvent;
import com.moonlit.logfaces.server.criteria.CriteriaFilter;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class SliceJob
extends Job {
    private LogDataModel model;
    private CriteriaFilter criteria;
    private String viewName;
    private Fetcher fetcher;

    public SliceJob(String viewName, LogDataModel model, CriteriaFilter criteria) {
        super("Slicing " + viewName);
        this.viewName = viewName;
        this.model = model;
        this.criteria = criteria;
    }

    public IStatus run(IProgressMonitor monitor) {
        try {
            this.fetcher = new SliceFetcher();
            this.fetcher.run(null);
            Utils.displayQueryResults(this.fetcher);
        }
        catch (Exception e) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    class SliceFetcher
    implements Fetcher {
        LogDataModel outputModel;
        QueryVO query;

        SliceFetcher() {
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            this.outputModel = new Log4jModel();
            LogEvent event = SliceJob.this.model.getStorageData().get(0);
            this.query = new QueryVO();
            this.query.setName(SliceJob.this.viewName);
            this.query.setCriteria(SliceJob.this.criteria);
            this.query.setTimeRange(TimeRange.CUSTOM_RANGE, event.getLoggerTimeStamp(), event.getLoggerTimeStamp());
            for (LogEvent e : SliceJob.this.model.getViewData()) {
                if (!SliceJob.this.criteria.qualify((Object)e)) continue;
                this.outputModel.add(e);
            }
        }

        @Override
        public String getName() {
            return this.query.getName();
        }

        @Override
        public LogDataModel getResults() {
            return this.outputModel;
        }

        @Override
        public Throwable getError() {
            return null;
        }

        @Override
        public QueryVO getQuery() {
            return this.query;
        }

        @Override
        public void setQuery(QueryVO query) {
            this.query = query;
        }

        @Override
        public long getQueryTime() {
            return 0L;
        }

        @Override
        public void dispose() {
            this.outputModel.clear();
        }
    }
}

