/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.jobs;

import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.WorkspaceHolder;
import com.moonlit.logfaces.client.editors.SourceCodeEdiorInput;
import com.moonlit.logfaces.client.editors.SourceCodeEditor;
import com.moonlit.logfaces.client.model.SourceIndexModel;
import com.moonlit.logfaces.client.model.SourceMappingModel;
import com.moonlit.logfaces.client.model.UrlVO;
import com.moonlit.logfaces.client.utils.BasicAuthenticator;
import com.moonlit.logfaces.client.utils.StringUtils;
import com.moonlit.logfaces.client.utils.Utils;
import java.io.File;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;

public class ShowSourceJob
extends Job {
    private String fileName;
    private int lineNumber;
    private IWorkbenchWindow window;
    private String urlPath = "";
    private String LINE_SEP = System.getProperty("line.separator");
    private BasicAuthenticator authenticator = BasicAuthenticator.getInstance();
    private UrlVO remote;

    public ShowSourceJob(IWorkbenchWindow window, String fileName, String urlPath, int line) {
        super("looking up " + fileName);
        this.fileName = fileName;
        this.urlPath = urlPath;
        this.lineNumber = line;
        this.window = window;
    }

    public IStatus run(IProgressMonitor monitor) {
        List<File> files = SourceIndexModel.getInstance().getFiles(this.fileName);
        String path = StringUtils.replace(this.urlPath, "/", File.separator);
        if (files.size() > 0) {
            for (File file : files) {
                if (!file.getPath().contains(path)) continue;
                this.displaySourceFile(file);
                return Status.OK_STATUS;
            }
            Utils.displayWarning("Source file not found", "Unable to locate " + this.fileName + this.LINE_SEP + this.LINE_SEP + "Possible reasons:" + this.LINE_SEP + "(1) Source directories are not specified - use Preferences/Files" + this.LINE_SEP + "(2) Source is new - rebuild file indexes from Tools menu" + this.LINE_SEP + "(3) Source URL's aren't specified" + this.LINE_SEP + "(4) Source file doesn't exist");
            return Status.OK_STATUS;
        }
        File sourceFile = this.searchUrls();
        if (sourceFile != null) {
            this.displaySourceFile(sourceFile);
            return Status.OK_STATUS;
        }
        Utils.displayWarning("Source file not found", "Unable to locate " + this.fileName + this.LINE_SEP + this.LINE_SEP + "Possible reasons:" + this.LINE_SEP + "(1) Source directories are not specified - use Preferences/Files" + this.LINE_SEP + "(2) Source is new - rebuild file indexes from Tools menu" + this.LINE_SEP + "(3) Source URL's aren't specified" + this.LINE_SEP + "(4) Source file doesn't exist");
        return Status.OK_STATUS;
    }

    private File searchUrls() {
        File file = new File(WorkspaceHolder.getInstance().getTempDirectoryName() + File.separator + this.fileName);
        this.remote = SourceIndexModel.getInstance().getLocation(this.urlPath);
        if (this.download(this.remote, file)) {
            return file;
        }
        for (UrlVO location : SourceMappingModel.getInstance().getUrls()) {
            file.delete();
            if (!this.download(location, file)) continue;
            this.remote = location;
            return file;
        }
        this.remote = null;
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean download(UrlVO location, File destination) {
        if (location == null) {
            return false;
        }
        if (location.isProtected()) {
            return this.tryBasicAuth(location, destination);
        }
        try {
            CloseableHttpClient client = HttpClientBuilder.create().build();
            HttpGet request = new HttpGet(location.forPath(this.urlPath));
            request.setConfig(RequestConfig.custom().setRedirectsEnabled(false).build());
            HttpResponse response = client.execute((HttpUriRequest)request);
            switch (response.getStatusLine().getStatusCode()) {
                case 200: {
                    String responseString = new BasicResponseHandler().handleResponse(response);
                    FileUtils.write((File)destination, (CharSequence)responseString);
                    SourceIndexModel.getInstance().cacheLocation(this.urlPath, location);
                    return true;
                }
                case 301: 
                case 302: 
                case 307: 
                case 401: 
                case 403: {
                    location.resetCredentials();
                    return this.tryBasicAuth(location, destination);
                }
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    boolean tryBasicAuth(UrlVO location, File destination) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 2[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void displaySourceFile(final File file) {
        if (Application.getPrefs().getBoolean("lfs_editor_src", false)) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Utils.launchExternalEditor(file.getPath(), ShowSourceJob.this.lineNumber);
                }
            });
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                SourceCodeEdiorInput input = new SourceCodeEdiorInput((IPath)new Path(file.getPath()), ShowSourceJob.this.lineNumber, ShowSourceJob.this.remote != null ? ShowSourceJob.this.remote.forPath(ShowSourceJob.this.urlPath) : null);
                IWorkbenchPage page = ShowSourceJob.this.window.getActivePage();
                IEditorReference[] refs = page.getEditorReferences();
                if (refs == null) {
                    return;
                }
                int i = 0;
                while (i < refs.length) {
                    IEditorPart editor = refs[i].getEditor(false);
                    if (editor instanceof SourceCodeEditor && ((SourceCodeEditor)editor).getPartName().equals(file.getName())) {
                        ((SourceCodeEditor)editor).reload((IEditorInput)input);
                        page.activate((IWorkbenchPart)editor);
                        return;
                    }
                    ++i;
                }
                try {
                    page.openEditor((IEditorInput)input, "com.moonlit.logfaces.client.editors.SourceCodeEditor");
                }
                catch (PartInitException e) {
                    Utils.displayPopup("Error", e.getMessage(), true);
                }
            }
        });
    }
}

