/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.jobs;

import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.model.QueryVO;
import com.moonlit.logfaces.client.net.LfsConnector;
import com.moonlit.logfaces.client.utils.Utils;
import com.moonlit.logfaces.server.core.LogEvent;
import com.moonlit.logfaces.server.core.ReceiverType;
import com.moonlit.logfaces.server.remoting.LfsRemote;
import com.moonlit.logfaces.server.util.LogFile;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SaveQueryJob
extends Job {
    private QueryVO query;
    private String fileName;
    private FORMAT format;
    private boolean launchEditor;

    public SaveQueryJob(QueryVO query, String fileName, FORMAT format, boolean launchEditor) {
        super("Saving '" + query.getName() + "' to file");
        this.query = query;
        this.fileName = fileName;
        this.format = format;
        this.launchEditor = launchEditor;
    }

    private void launchExternalEditor() {
        IPreferencesService service = Platform.getPreferencesService();
        String editor = service.getString("com.moonlit.logfaces.client.plugin", "lfs_text_editor", "", null);
        try {
            Runtime.getRuntime().exec(editor + " " + this.fileName);
        }
        catch (IOException e) {
            Utils.displayPopup("Text editor not found", "Failed to launch external text editor. Please specify it's full path in preferences.", true);
        }
    }

    private void finalize(final long size, final long time) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (SaveQueryJob.this.format == FORMAT.FORMAT_BINARY) {
                    String msg = "Results are exported into\n " + SaveQueryJob.this.fileName + "\nThere are " + size + " records fetched in " + time + " sec";
                    MessageDialog.openInformation((Shell)Application.getShell(), (String)"Complete", (String)msg);
                    return;
                }
                if (!SaveQueryJob.this.launchEditor) {
                    String msg = "Results are saved in\n " + SaveQueryJob.this.fileName + "\nThere are " + size + " records fetched in " + time + " sec.\n\nWould you like to open it in text editor?";
                    if (MessageDialog.openQuestion((Shell)Application.getShell(), (String)"Complete", (String)msg)) {
                        SaveQueryJob.this.launchExternalEditor();
                    }
                } else {
                    SaveQueryJob.this.launchExternalEditor();
                }
            }
        });
    }

    protected IStatus run(IProgressMonitor monitor) {
        long startTime = System.currentTimeMillis();
        try {
            if (this.format == FORMAT.FORMAT_BINARY) {
                BinarySaver worker = null;
                worker = new BinarySaver();
                worker.run(monitor);
                if (worker.returnEx != null) {
                    Utils.displayPopup("Query failed", worker.returnEx.getMessage(), true);
                    return Status.OK_STATUS;
                }
                if (monitor.isCanceled()) {
                    return Status.OK_STATUS;
                }
                this.finalize(worker.fetchced, (System.currentTimeMillis() - startTime) / 1000L);
                return Status.OK_STATUS;
            }
            TextQuerySaver worker = new TextQuerySaver();
            worker.run(monitor);
            if (worker.returnEx != null) {
                Utils.displayPopup("Query failed", worker.returnEx.getMessage(), true);
                return Status.OK_STATUS;
            }
            if (monitor.isCanceled()) {
                return Status.OK_STATUS;
            }
            this.finalize(worker.fetchced, (System.currentTimeMillis() - startTime) / 1000L);
            return Status.OK_STATUS;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return Status.CANCEL_STATUS;
        }
    }

    class BinarySaver
    implements IRunnableWithProgress {
        Exception returnEx;
        long fetchced = 0L;

        BinarySaver() {
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException {
            List results;
            long start;
            ObjectOutputStream outputStream;
            String queryName;
            String sid;
            LfsRemote lfs;
            block15: {
                lfs = LfsConnector.getInstance().getConnection();
                sid = LfsConnector.getInstance().getSid();
                queryName = SaveQueryJob.this.query.getName();
                monitor.beginTask("Retrieving data..", SaveQueryJob.this.query.getLimit());
                outputStream = null;
                start = System.currentTimeMillis();
                outputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(SaveQueryJob.this.fileName, false)));
                results = lfs.queryBegin(sid, queryName, SaveQueryJob.this.query.toMap(), 500, -1);
                if (results != null) break block15;
                monitor.setCanceled(true);
                Utils.displayPopup(SaveQueryJob.this.query.getName(), "There is no data", false);
                IOUtils.closeQuietly((OutputStream)outputStream);
                try {
                    lfs.queryEnd(sid, queryName);
                }
                catch (Exception e) {
                    this.returnEx = e;
                    monitor.setCanceled(true);
                }
                return;
            }
            try {
                try {
                    while (results != null) {
                        for (LogEvent event : results) {
                            outputStream.writeObject(event);
                        }
                        outputStream.flush();
                        outputStream.reset();
                        this.fetchced += (long)results.size();
                        monitor.subTask("fetched: " + this.fetchced + " records, avg. speed: " + this.fetchced * 1000L / (System.currentTimeMillis() - start) + " rec/sec");
                        monitor.worked(results.size());
                        results.clear();
                        results = null;
                        results = lfs.queryNext(sid, queryName);
                        if (!monitor.isCanceled()) continue;
                        break;
                    }
                }
                catch (Exception ex) {
                    this.returnEx = ex;
                    monitor.setCanceled(true);
                    IOUtils.closeQuietly(outputStream);
                    try {
                        lfs.queryEnd(sid, queryName);
                    }
                    catch (Exception e) {
                        this.returnEx = e;
                        monitor.setCanceled(true);
                    }
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStream);
                try {
                    lfs.queryEnd(sid, queryName);
                }
                catch (Exception e) {
                    this.returnEx = e;
                    monitor.setCanceled(true);
                }
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)outputStream);
            try {
                lfs.queryEnd(sid, queryName);
            }
            catch (Exception e) {
                this.returnEx = e;
                monitor.setCanceled(true);
            }
        }
    }

    public static enum FORMAT {
        FORMAT_XML,
        FORMAT_TEXT,
        FORMAT_BINARY;

    }

    class TextQuerySaver
    implements IRunnableWithProgress {
        Exception returnEx;
        long fetchced = 0L;

        TextQuerySaver() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run(IProgressMonitor monitor) throws InvocationTargetException {
            LfsRemote lfs = LfsConnector.getInstance().getConnection();
            LogFile logFile = Utils.makeLogFile(ReceiverType.log4j, SaveQueryJob.this.fileName);
            String sid = LfsConnector.getInstance().getSid();
            String qid = "" + System.currentTimeMillis();
            monitor.beginTask("Retrieving data..", SaveQueryJob.this.query.getLimit());
            try {
                long start = System.currentTimeMillis();
                List results = lfs.queryBegin(sid, qid, SaveQueryJob.this.query.toMap(), 500, -1);
                if (results == null) {
                    monitor.setCanceled(true);
                    Utils.displayPopup(SaveQueryJob.this.query.getName(), "There is no data", false);
                    return;
                }
                try {
                    logFile.initialize();
                    do {
                        logFile.write((Collection)results);
                        this.fetchced += (long)results.size();
                        monitor.subTask("fetched: " + this.fetchced + " records, avg. speed: " + this.fetchced * 1000L / (System.currentTimeMillis() - start) + " rec/sec");
                        monitor.worked(results.size());
                        results = lfs.queryNext(sid, qid);
                        if (monitor.isCanceled()) return;
                    } while (results != null);
                    return;
                }
                catch (Exception ex) {
                    this.returnEx = ex;
                    monitor.setCanceled(true);
                }
                return;
            }
            finally {
                try {
                    logFile.terminate();
                    lfs.queryEnd(sid, qid);
                }
                catch (Exception e) {
                    this.returnEx = e;
                    monitor.setCanceled(true);
                }
            }
        }
    }
}

