/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.jobs;

import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.jobs.Saver;
import com.moonlit.logfaces.client.types.FileFormat;
import com.moonlit.logfaces.client.utils.Utils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SaveDataJob
extends Job {
    private boolean launchEditor;
    private Saver saver;

    public SaveDataJob(Saver saver, boolean launchEditor) {
        super("Saving '" + saver.getName() + "' to file");
        this.launchEditor = launchEditor;
        this.saver = saver;
    }

    private void finalize(final long size, final long time) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (SaveDataJob.this.saver.getFormat() == FileFormat.binary) {
                    String msg = "Results are exported into\n " + SaveDataJob.this.saver.getFileName() + "\nThere are " + size + " records fetched in " + time + " sec";
                    MessageDialog.openInformation((Shell)Application.getShell(), (String)"Complete", (String)msg);
                    return;
                }
                if (!SaveDataJob.this.launchEditor) {
                    String msg = "Results are saved in\n " + SaveDataJob.this.saver.getFileName() + "\nThere are " + size + " records fetched in " + time + " sec.\n\nWould you like to open it in text editor?";
                    if (MessageDialog.openQuestion((Shell)Application.getShell(), (String)"Complete", (String)msg)) {
                        Utils.launchExternalEditor(SaveDataJob.this.saver.getFileName(), 0);
                    }
                } else {
                    Utils.launchExternalEditor(SaveDataJob.this.saver.getFileName(), 0);
                }
            }
        });
    }

    protected IStatus run(IProgressMonitor monitor) {
        long startTime = System.currentTimeMillis();
        try {
            this.saver.run(monitor);
            if (this.saver.getError() != null) {
                Utils.displayPopup("Saving failed", this.saver.getError().getMessage(), true);
                return Status.OK_STATUS;
            }
            if (this.saver.getNofFetched() == 0L) {
                Utils.displayPopup(this.saver.getName(), "There is no data", false);
                return Status.OK_STATUS;
            }
            if (monitor.isCanceled()) {
                return Status.OK_STATUS;
            }
            this.finalize(this.saver.getNofFetched(), (System.currentTimeMillis() - startTime) / 1000L);
            return Status.OK_STATUS;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return Status.CANCEL_STATUS;
        }
    }
}

