/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.jobs;

import com.moonlit.logfaces.client.utils.Utils;
import com.moonlit.logfaces.server.core.LogEvent;
import com.moonlit.logfaces.server.core.LogFacesPlugin;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class RunPluginJob
extends Job {
    private LogFacesPlugin plugin;
    private List<LogEvent> events;
    private Map<String, String> args;
    private static Logger log = LogManager.getLogger(RunPluginJob.class);

    public RunPluginJob(LogFacesPlugin plugin, List<LogEvent> events, Map<String, String> args) {
        super(String.format("Calling plugin '%s'", plugin.getName()));
        this.plugin = plugin;
        this.events = events;
        this.args = args;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            Object result = this.plugin.handleEvents(this.events, this.args);
            Utils.displayPopup(this.plugin.getName(), result != null ? result.toString() : "empty response calling this plugin", false);
            return Status.OK_STATUS;
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            Utils.displayException(this.plugin.getName(), "Plugin call failed, click on 'Details' button to see the cause.", ex);
            return Status.CANCEL_STATUS;
        }
    }
}

