/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.jobs;

import com.moonlit.logfaces.client.LoginHandler;
import com.moonlit.logfaces.client.Workspace;
import com.moonlit.logfaces.client.WorkspaceHolder;
import com.moonlit.logfaces.client.net.LfsConnector;
import com.moonlit.logfaces.client.utils.Utils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class ReconnectJob
extends Job {
    private LfsConnector connector = LfsConnector.getInstance();
    private boolean reconnect;
    private static Logger log = LogManager.getLogger(ReconnectJob.class);

    public ReconnectJob(boolean reconnect) {
        super("Connecting to logFaces server");
        this.reconnect = reconnect;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            if (this.reconnect) {
                this.connector.terminate();
                this.connector.connect(monitor);
            }
            if (this.connector.isLoginRequired()) {
                LoginHandler.getInstance().login();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Workspace ws = WorkspaceHolder.getInstance().getCurrentWorkspace();
            Utils.displayWarning(ws.getServerHost() + ":" + ws.getServerPort() + " not available", e.getMessage());
        }
        return Status.OK_STATUS;
    }
}

