/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.jobs;

import com.moonlit.logfaces.client.model.QueryVO;
import com.moonlit.logfaces.client.net.LfsConnector;
import com.moonlit.logfaces.client.types.TimeRange;
import com.moonlit.logfaces.client.views.DistributionDataListener;
import com.moonlit.logfaces.server.stats.StatCategory;
import com.moonlit.logfaces.server.vo.StatVO;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class QueryDistributionJob
extends Job {
    private QueryVO query;
    private TimeRange rate;
    private StatCategory category;
    private DistributionDataListener listener;
    private static Logger log = LogManager.getLogger(QueryDistributionJob.class);

    public QueryDistributionJob(QueryVO query, TimeRange rate, DistributionDataListener listener) {
        super("Statisical distributions");
        this.query = query;
        this.rate = rate;
        this.category = StatCategory.level;
        this.listener = listener;
    }

    public QueryDistributionJob(QueryVO query, TimeRange rate, StatCategory category, DistributionDataListener listener) {
        super("Statisical distributions");
        this.query = query;
        this.rate = rate;
        this.category = category;
        this.listener = listener;
    }

    protected IStatus run(IProgressMonitor monitor) {
        Map<String, Object> params = this.query.toMap();
        params.put("statcategory", this.category);
        params.put("statrate", this.rate.getRangeAdjusted(this.query.getToTime() - this.query.getFromTime(), 100));
        try {
            LfsConnector connector = LfsConnector.getInstance();
            String sid = connector.getSid();
            List stats = connector.getConnection().queryDistribution(sid, params);
            if (stats == null || stats.size() == 0) {
                this.listener.handleDistributionData(null);
                return Status.OK_STATUS;
            }
            for (StatVO vo : stats) {
                if (vo.getCount() == 0.0f) continue;
                this.listener.handleDistributionData(stats);
                return Status.OK_STATUS;
            }
        }
        catch (RemoteException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        this.listener.handleDistributionData(null);
        return Status.OK_STATUS;
    }
}

