/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.jobs;

import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.jobs.Fetcher;
import com.moonlit.logfaces.client.model.QueryVO;
import com.moonlit.logfaces.client.model.data.Log4jModel;
import com.moonlit.logfaces.client.model.data.LogDataModel;
import com.moonlit.logfaces.client.model.data.LogModelEvent;
import com.moonlit.logfaces.client.net.LfsConnector;
import com.moonlit.logfaces.client.utils.Compatibility;
import com.moonlit.logfaces.client.utils.StringUtils;
import com.moonlit.logfaces.client.utils.Utils;
import com.moonlit.logfaces.server.core.LogEvent;
import com.moonlit.logfaces.server.criteria.CriteriaFilter;
import com.moonlit.logfaces.server.remoting.LfsRemote;
import com.moonlit.logfaces.server.util.JsonEventParser;
import com.moonlit.logfaces.server.vo.AlertVO;
import com.moonlit.logfaces.server.vo.LoggingEventVO;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;

public class QueryDataFetcher
implements Fetcher {
    private LogDataModel model;
    private LogEvent drillEvent;
    private Throwable returnEx;
    private QueryVO query;
    private CriteriaFilter criteria;
    private Map<String, String> params;
    private int pageSize;
    private long startTime;
    private long queryTime;
    private boolean rapid;
    private boolean pin;
    private boolean done;
    private static final Logger log = LogManager.getLogger(QueryDataFetcher.class);

    public QueryDataFetcher(QueryVO query, boolean rapid) {
        this.query = query;
        this.rapid = rapid;
        this.pin = query.isPin();
        this.model = new Log4jModel();
        this.criteria = query.getCriteria().clone();
        this.params = Utils.parameterizeCriteria(this.criteria);
        if (this.params == null) {
            this.done = true;
        }
    }

    public QueryDataFetcher(QueryVO query, LogEvent drillEvent, boolean rapid) {
        this(query, rapid);
        this.drillEvent = drillEvent;
        this.model = new Log4jModel();
    }

    public QueryDataFetcher(QueryVO query, LogDataModel reuseModel, boolean rapid) {
        this(query, rapid);
        if (reuseModel != null) {
            reuseModel.clear();
            System.gc();
        }
        this.model = reuseModel != null ? reuseModel : new Log4jModel();
    }

    public QueryDataFetcher(AlertVO alert) {
        this(new QueryVO(alert.getQuery()), true);
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        if (this.done) {
            monitor.setCanceled(true);
            return;
        }
        boolean stream = Compatibility.canUseTurboQuery() && Application.getPrefs().getBoolean("lfs_query_stream", true);
        boolean compress = Application.getPrefs().getBoolean("lfs_query_compress", true);
        this.pageSize = Application.getPrefs().getInt("lfs_query_page", 100);
        if (stream) {
            this.runTurbo(monitor, compress);
        } else {
            this.runPaging(monitor);
        }
    }

    public void runTurbo(IProgressMonitor monitor, boolean compress) throws InvocationTargetException, InterruptedException {
        block17: {
            this.returnEx = null;
            LfsRemote connection = LfsConnector.getInstance().getConnection();
            if (connection == null) {
                monitor.setCanceled(true);
                return;
            }
            log.info("turbo query starts for '{}'", (Object)this.getName());
            this.startTime = System.currentTimeMillis();
            String sid = LfsConnector.getInstance().getSid();
            String qid = Long.toString(this.startTime);
            BufferedReader decoder = null;
            try {
                try {
                    Map<String, Object> params = this.query.toMap();
                    params.put("criteria", this.criteria);
                    params.put("compress", compress);
                    InputStream is = connection.queryTurbo(sid, qid, params);
                    JsonEventParser parser = new JsonEventParser();
                    monitor.beginTask("Streaming logs from database", this.query.getLimit());
                    decoder = compress ? new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(is), "UTF-8")) : new BufferedReader(new InputStreamReader(is, "UTF-8"));
                    while (!monitor.isCanceled()) {
                        String line = decoder.readLine();
                        if (line != null) {
                            LoggingEventVO event = parser.parse(line);
                            if (event == null) continue;
                            this.model.add((LogEvent)event);
                            if (this.pin && this.query.isPinned(event.getSequenceNumber())) {
                                this.model.addBookmark((LogEvent)event);
                            }
                            if (this.rapid) {
                                Utils.displayQueryResults(this);
                                this.rapid = false;
                            }
                            if (this.model.getSize() % 1000 != 0) continue;
                            monitor.subTask("" + this.model.getSize());
                            monitor.worked(this.model.getSize());
                            this.model.fireUpdate(LogModelEvent.ADDED);
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    this.returnEx = e;
                    Throwable cause = e.getCause();
                    if (cause != null) {
                        this.returnEx = cause;
                    }
                    log.info("turbo query ends");
                    this.done = true;
                    IOUtils.closeQuietly(decoder);
                    try {
                        this.queryTime = System.currentTimeMillis() - this.startTime;
                        this.model.setDrillEvent(this.drillEvent);
                        this.model.setSelectedEvent(this.model.getViewItem(0));
                        Thread.sleep(200L);
                        this.model.fireUpdate(LogModelEvent.FINALIZED);
                    }
                    catch (Exception e2) {
                        this.returnEx = e2;
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                log.info("turbo query ends");
                this.done = true;
                IOUtils.closeQuietly(decoder);
                try {
                    this.queryTime = System.currentTimeMillis() - this.startTime;
                    this.model.setDrillEvent(this.drillEvent);
                    this.model.setSelectedEvent(this.model.getViewItem(0));
                    Thread.sleep(200L);
                    this.model.fireUpdate(LogModelEvent.FINALIZED);
                }
                catch (Exception e) {
                    this.returnEx = e;
                }
                throw throwable;
            }
            log.info("turbo query ends");
            this.done = true;
            IOUtils.closeQuietly((Reader)decoder);
            try {
                this.queryTime = System.currentTimeMillis() - this.startTime;
                this.model.setDrillEvent(this.drillEvent);
                this.model.setSelectedEvent(this.model.getViewItem(0));
                Thread.sleep(200L);
                this.model.fireUpdate(LogModelEvent.FINALIZED);
            }
            catch (Exception e) {
                this.returnEx = e;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runPaging(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        List fetched;
        int maxResults;
        int got;
        String qid;
        String sid;
        LfsRemote connection;
        block25: {
            this.model.clear();
            this.returnEx = null;
            connection = LfsConnector.getInstance().getConnection();
            if (connection == null) {
                monitor.setCanceled(true);
                return;
            }
            log.info("paging query starts for '{}'", (Object)this.query.getName());
            this.startTime = System.currentTimeMillis();
            sid = LfsConnector.getInstance().getSid();
            qid = Long.toString(this.startTime);
            got = 0;
            maxResults = this.query.getLimit();
            Map<String, Object> params = this.query.toMap();
            params.put("criteria", this.criteria);
            fetched = connection.queryBegin(sid, qid, params, this.pageSize, maxResults);
            monitor.beginTask("Retrieving log from database..", maxResults);
            if (fetched != null) break block25;
            log.info("paging query ends");
            this.done = true;
            try {
                connection.queryEnd(sid, qid);
                this.queryTime = System.currentTimeMillis() - this.startTime;
                this.model.setDrillEvent(this.drillEvent);
                this.model.setSelectedEvent(this.model.getViewItem(0));
                if (this.pin) {
                    for (LogEvent event : this.model.getStorageData()) {
                        if (!this.query.isPinned(event.getSequenceNumber())) continue;
                        this.model.addBookmark(event);
                    }
                }
                this.model.fireUpdate(LogModelEvent.FINALIZED);
                return;
            }
            catch (RemoteException e) {
                this.returnEx = e;
            }
            return;
        }
        try {
            try {
                this.model.addAll(fetched);
                if (this.rapid) {
                    Utils.displayQueryResults(this);
                    this.rapid = false;
                }
                do {
                    monitor.subTask("getting results " + (got += fetched.size()));
                    fetched = connection.queryNext(sid, qid);
                    if (fetched == null) break;
                    if (got >= maxResults && maxResults > 0) {
                    }
                    monitor.worked(fetched.size());
                    this.model.addAll(fetched);
                    if (Utils.gotHeap()) continue;
                    monitor.setCanceled(true);
                    this.returnEx = new Exception("There is not enough memory to contain all query results. Please adjust -Xmx variables in logfaces.ini file to allow larger data allocations, or close unused windows.");
                } while (!monitor.isCanceled());
            }
            catch (Exception e) {
                this.returnEx = e;
                Throwable cause = e.getCause();
                if (cause != null) {
                    this.returnEx = cause;
                }
                log.info("paging query ends");
                this.done = true;
                try {
                    connection.queryEnd(sid, qid);
                    this.queryTime = System.currentTimeMillis() - this.startTime;
                    this.model.setDrillEvent(this.drillEvent);
                    this.model.setSelectedEvent(this.model.getViewItem(0));
                    if (this.pin) {
                        for (LogEvent event : this.model.getStorageData()) {
                            if (!this.query.isPinned(event.getSequenceNumber())) continue;
                            this.model.addBookmark(event);
                        }
                    }
                    this.model.fireUpdate(LogModelEvent.FINALIZED);
                    return;
                }
                catch (RemoteException e2) {
                    this.returnEx = e2;
                    return;
                }
            }
        }
        catch (Throwable throwable) {}
        finally {
            log.info("paging query ends");
            this.done = true;
            try {
                connection.queryEnd(sid, qid);
                this.queryTime = System.currentTimeMillis() - this.startTime;
                this.model.setDrillEvent(this.drillEvent);
                this.model.setSelectedEvent(this.model.getViewItem(0));
                if (this.pin) {
                    for (LogEvent event : this.model.getStorageData()) {
                        if (!this.query.isPinned(event.getSequenceNumber())) continue;
                        this.model.addBookmark(event);
                    }
                }
                this.model.fireUpdate(LogModelEvent.FINALIZED);
                return;
            }
            catch (RemoteException e) {
                this.returnEx = e;
            }
        }
    }

    @Override
    public void dispose() {
        this.model.clear();
        this.done = false;
        this.returnEx = null;
    }

    @Override
    public Throwable getError() {
        return this.returnEx;
    }

    @Override
    public LogDataModel getResults() {
        return this.model;
    }

    @Override
    public String getName() {
        if (this.params != null && !this.params.isEmpty()) {
            String values = StringUtils.collectionToCommaDelimitedString(this.params.values());
            return String.format("%s (%s)", this.query.getName(), values);
        }
        return this.query.getName();
    }

    @Override
    public QueryVO getQuery() {
        return this.query;
    }

    @Override
    public void setQuery(QueryVO query) {
        CriteriaFilter criteria = query.getCriteria().clone();
        if (Utils.parameterizeCriteria(criteria, this.params) != null) {
            this.query = query;
            this.criteria = criteria;
        }
    }

    @Override
    public long getQueryTime() {
        return this.done ? this.queryTime : System.currentTimeMillis() - this.startTime;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }
}

