/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.jobs;

import com.moonlit.logfaces.client.editors.LogEditor;
import com.moonlit.logfaces.client.jobs.Fetcher;
import com.moonlit.logfaces.client.jobs.QueryDataFetcher;
import com.moonlit.logfaces.client.model.QueryVO;
import com.moonlit.logfaces.client.model.data.LogModelEvent;
import com.moonlit.logfaces.client.types.TimeRange;
import com.moonlit.logfaces.client.utils.Utils;
import com.moonlit.logfaces.server.criteria.CriteriaFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.swt.widgets.Display;

public class PerspectiveActivatorJob
extends Job {
    private Fetcher fetcher;
    private int prefetchTime;
    private LogEditor target;
    private CriteriaFilter criteria;
    private static Logger log = LogManager.getLogger(PerspectiveActivatorJob.class);

    public PerspectiveActivatorJob(LogEditor target, CriteriaFilter criteria) {
        super("Getting '" + target.getPartName() + "' latest events");
        this.target = target;
        this.criteria = criteria;
        IPreferencesService service = Platform.getPreferencesService();
        this.prefetchTime = service.getInt("com.moonlit.logfaces.client.plugin", "lfs_prefetch_time", 10, null);
    }

    protected IStatus run(IProgressMonitor monitor) {
        block6: {
            if (this.criteria.getRules().size() == 0) {
                return Status.OK_STATUS;
            }
            try {
                try {
                    long now = System.currentTimeMillis();
                    QueryVO qvo = new QueryVO(this.target.getPartName());
                    qvo.setCriteria(this.criteria);
                    qvo.setTimeRange(TimeRange.CUSTOM_RANGE, now - (long)this.prefetchTime * 60000L, now);
                    qvo.setLimit(-1);
                    this.fetcher = new QueryDataFetcher(qvo, false);
                    this.fetcher.run(monitor);
                }
                catch (Exception ex) {
                    log.error(ex.getMessage(), (Throwable)ex);
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            PerspectiveActivatorJob.this.target.activate(PerspectiveActivatorJob.this.fetcher.getResults().getStorageData());
                            Utils.sleep(200);
                            PerspectiveActivatorJob.this.target.getModel().fireUpdate(LogModelEvent.FINALIZED);
                        }
                    });
                    break block6;
                }
            }
            catch (Throwable throwable) {
                Display.getDefault().asyncExec(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
            Display.getDefault().asyncExec(new /* invalid duplicate definition of identical inner class */);
        }
        return Status.OK_STATUS;
    }
}

