/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.jobs;

import com.moonlit.logfaces.client.jobs.Fetcher;
import com.moonlit.logfaces.client.model.ParserVO;
import com.moonlit.logfaces.client.model.QueryVO;
import com.moonlit.logfaces.client.model.data.Log4jModel;
import com.moonlit.logfaces.client.model.data.LogDataModel;
import com.moonlit.logfaces.server.conf.Options;
import com.moonlit.logfaces.server.core.LogEvent;
import com.moonlit.logfaces.server.receivers.Parser;
import com.moonlit.logfaces.server.receivers.ParserListener;
import com.moonlit.logfaces.server.util.Patterns;
import com.moonlit.logfaces.server.vo.LoggingEventVO;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;

public class LogFileParser
implements Fetcher {
    private IProgressMonitor monitor;
    private LogDataModel model;
    private File file;
    private ParserVO parserVO;
    private Throwable error;
    private long parseTime;

    public LogFileParser(File file, ParserVO parserVO) {
        this.file = file;
        this.parserVO = parserVO;
        this.model = new Log4jModel();
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        long start = System.currentTimeMillis();
        this.monitor = monitor;
        this.model.clear();
        Parser parser = new Parser((ParserListener)new ThisListener(), Patterns.getInstance().getFileName());
        Options options = new Options();
        options.setProperty("pattern", (Object)this.parserVO.getPattern());
        options.setProperty("xpattern", (Object)this.parserVO.getPatternEx());
        options.setProperty("dtf", (Object)this.parserVO.getDtf());
        parser.parse(this.file, options, 0L);
        this.parseTime = System.currentTimeMillis() - start;
    }

    @Override
    public void dispose() {
        this.model.clear();
    }

    @Override
    public Throwable getError() {
        return this.error;
    }

    @Override
    public LogDataModel getResults() {
        return this.model;
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public QueryVO getQuery() {
        QueryVO vo = new QueryVO();
        vo.setName(this.file.getName());
        vo.setHeaders(this.parserVO.getHeaders());
        return vo;
    }

    @Override
    public long getQueryTime() {
        return this.parseTime;
    }

    @Override
    public void setQuery(QueryVO query) {
    }

    class ThisListener
    implements ParserListener {
        private long start = System.currentTimeMillis();
        private int failed;
        private int total;

        ThisListener() {
        }

        public void parsingStarted() {
            LogFileParser.this.monitor.beginTask("Parsing file", 100);
        }

        public void lineParsed(LogEvent event) throws Exception {
            if (event instanceof LoggingEventVO && event.getSequenceNumber() == 0L) {
                ((LoggingEventVO)event).setSequenceNumber(++this.start);
            }
            LogFileParser.this.model.add(event);
            ++this.total;
            LogFileParser.this.monitor.subTask(String.format("Processed %d events, failed: %d lines", this.total, this.failed));
            LogFileParser.this.monitor.worked(this.total);
        }

        public void lineFailed(String line) {
            ++this.failed;
            ++this.total;
        }

        public void parsingEnded(long seek) {
        }

        public void parsingFailed(Throwable e, long seek) {
            LogFileParser.this.monitor.setCanceled(true);
            LogFileParser.this.error = e;
        }
    }
}

