/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.jobs;

import com.moonlit.logfaces.client.Workspace;
import com.moonlit.logfaces.client.types.LfcEvent;
import com.moonlit.logfaces.client.utils.Utils;
import com.moonlit.logfaces.server.util.LfsEventBus;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;

public class LoadWorkspaceJob
extends Job {
    private Workspace workspace;
    private Logger log = LogManager.getLogger(LoadWorkspaceJob.class);

    public LoadWorkspaceJob(Workspace workspace) {
        super(String.format("loading '%s'", workspace.getName()));
        this.workspace = workspace;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            this.workspace.load();
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            Utils.displayPopup("Workspace didn't load properly", e.getMessage(), true);
            return Status.OK_STATUS;
        }
        Display.getDefault().asyncExec(() -> LfsEventBus.getInstance().post((Object)LfcEvent.workspaceLoaded(this.workspace.getName())));
        return Status.OK_STATUS;
    }
}

