/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.jobs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.utils.Utils;
import java.io.File;
import java.io.InputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.StringMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public class JiraJob
extends Job {
    private IEclipsePreferences prefs;
    private File template;
    private File attachment;
    private String subject;
    private String description;
    private Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static Logger log = LogManager.getLogger(JiraJob.class);

    public JiraJob(String subject, String description, String template, File attachment) {
        super("Talking to your JIRA via its API, please wait...");
        this.subject = subject;
        this.attachment = attachment;
        this.description = description;
        this.template = new File(template);
        this.prefs = Application.getPrefs();
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            this.createIssue();
        }
        catch (Exception e) {
            Utils.displayError("Failed creating JIRA issue", e.getMessage());
            return Status.CANCEL_STATUS;
        }
        Utils.displayPopup("JIRA API call", "Issue is created successfully", false);
        return Status.OK_STATUS;
    }

    private void createIssue() throws Exception {
        String url = this.prefs.get("jira_url", "https://xxx.atlassian.net/rest/api/3/issue");
        String user = this.prefs.get("jira_user", "");
        String token = this.prefs.get("jira_token", "");
        String secret = String.format("%s:%s", user, token);
        if (StringUtils.isEmpty((CharSequence)url) || StringUtils.isEmpty((CharSequence)secret)) {
            throw new Exception("jira integration properties not defined, request ignored");
        }
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        String auth = new String(Base64.encodeBase64((byte[])secret.getBytes()));
        String body = this.createBody();
        HttpPost post = new HttpPost(url);
        post.setHeader("Accept", "*/*");
        post.setHeader("Content-Type", "application/json");
        post.setHeader("Authorization", String.format("Basic %s", auth));
        post.setEntity((HttpEntity)new StringEntity(body, "UTF-8"));
        HttpResponse hr = httpclient.execute((HttpUriRequest)post);
        HttpEntity entity = hr.getEntity();
        String content = IOUtils.toString((InputStream)entity.getContent(), (String)"UTF-8");
        if (hr.getStatusLine().getStatusCode() != 201) {
            throw new Exception(String.format("%s%n%s", hr.getStatusLine(), content));
        }
        StringMap response = (StringMap)this.gson.fromJson(content, StringMap.class);
        EntityUtils.consumeQuietly((HttpEntity)entity);
        url = String.format("%s/attachments", (Object[])response.getValue("self"));
        post = new HttpPost(url);
        post.setHeader("Accept", "*/*");
        post.setHeader("Authorization", String.format("Basic %s", auth));
        post.setHeader("X-Atlassian-Token", "nocheck");
        post.setEntity((HttpEntity)new StringEntity(body, "UTF-8"));
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.addPart("file", (ContentBody)new FileBody(this.attachment, ContentType.DEFAULT_BINARY, "lfs-attachment.log"));
        post.setEntity(builder.build());
        hr = httpclient.execute((HttpUriRequest)post);
        entity = hr.getEntity();
        content = IOUtils.toString((InputStream)entity.getContent(), (String)"UTF-8");
        if (hr.getStatusLine().getStatusCode() != 200) {
            throw new Exception(String.format("%s%n%s", hr.getStatusLine(), content));
        }
        log.info("jira issue created successfully");
        FileUtils.deleteQuietly((File)this.attachment);
    }

    private String createBody() throws Exception {
        if (!this.template.exists()) {
            throw new Exception("No template file");
        }
        String body = FileUtils.readFileToString((File)this.template);
        body = StringUtils.replace((String)body, (String)"${summary}", (String)Utils.safeJson(this.subject, true));
        if ((body = StringUtils.replace((String)body, (String)"${description}", (String)Utils.safeJson(this.description))).contains("${logs}")) {
            String abbreviation = Utils.safeJson(Utils.abbreaviate(this.attachment, 3));
            body = StringUtils.replace((String)body, (String)"${logs}", (String)abbreviation);
        }
        return body;
    }
}

