/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.jobs;

import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.jobs.BinaryImporter;
import com.moonlit.logfaces.client.jobs.Importer;
import com.moonlit.logfaces.client.jobs.XmlImporter;
import com.moonlit.logfaces.client.net.LfsConnector;
import com.moonlit.logfaces.client.utils.Utils;
import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ImportDataJob
extends Job {
    private String fileName;
    private String domain;
    private Importer importer;

    public ImportDataJob(String fileName, String domain) {
        super("Importing");
        this.fileName = fileName;
        this.domain = domain;
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.importer = this.fileName.contains("xml") ? new XmlImporter(new File(this.fileName), this.domain) : new BinaryImporter(new File(this.fileName), this.domain);
        final long startTime = System.currentTimeMillis();
        try {
            this.importer.run(monitor);
            LfsConnector.getInstance().reloadRepository();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Throwable error = this.importer.getLastError();
        if (error != null) {
            Utils.displayPopup("Import failed", error.getMessage() == null ? error.toString() : error.getMessage(), true);
            return Status.OK_STATUS;
        }
        if (monitor.isCanceled()) {
            return Status.OK_STATUS;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (ImportDataJob.this.importer.getImported() == 0L) {
                    MessageDialog.openError((Shell)Application.getShell(), (String)"No data was imported", (String)"Nothing could be imported from specified file.\n\n1) Please check the validity of data in the file.\n2) Please check LFS internal log for more details.");
                    return;
                }
                String msg = String.format("Records imported: %d%nRecords failed: %d%nOperation time: %d sec", ImportDataJob.this.importer.getImported(), ImportDataJob.this.importer.getFailed(), (System.currentTimeMillis() - startTime) / 1000L);
                if (ImportDataJob.this.importer.getFailed() > 0L) {
                    MessageDialog.openWarning((Shell)Application.getShell(), (String)"Some records didn't get imported", (String)msg);
                } else {
                    MessageDialog.openInformation((Shell)Application.getShell(), (String)"Data is imported successfully", (String)msg);
                }
            }
        });
        return Status.OK_STATUS;
    }
}

