/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.jobs;

import com.moonlit.logfaces.client.net.LfsConnector;
import com.moonlit.logfaces.client.views.ExceptionView;
import com.moonlit.logfaces.server.criteria.EventAttribute;
import com.moonlit.logfaces.server.remoting.LfsRemote;
import com.moonlit.logfaces.server.vo.LoggingEventVO;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class FetchStackTracesJob
extends Job {
    private LoggingEventVO event;
    private ExceptionView view;

    public FetchStackTracesJob(LoggingEventVO event) {
        super("Fetching stack traces, one moment...");
        this.event = event;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            this.view = (ExceptionView)window.getActivePage().findView("com.moonlit.logfaces.client.ExceptionView");
        }
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (this.view == null) {
            return Status.OK_STATUS;
        }
        try {
            LfsRemote connection = LfsConnector.getInstance().getConnection();
            Object value = connection.queryOne(LfsConnector.getInstance().getSid(), this.event.getId(), EventAttribute.throwableInfo.name());
            this.event.setThrowableInfo(value.toString());
        }
        catch (Exception e1) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    FetchStackTracesJob.this.view.displayNote("Unabled to fetch stack traces");
                }
            });
            return Status.OK_STATUS;
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                FetchStackTracesJob.this.view.display(FetchStackTracesJob.this.event);
            }
        });
        return Status.OK_STATUS;
    }
}

