/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.jobs;

import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.jobs.FetchRepoHostsJob;
import com.moonlit.logfaces.client.model.RepositoryModel;
import com.moonlit.logfaces.client.net.LfsConnector;
import com.moonlit.logfaces.client.utils.Compatibility;
import com.moonlit.logfaces.client.utils.Utils;
import com.moonlit.logfaces.server.remoting.LfsRemote;
import com.moonlit.logfaces.server.util.JsonEventParser;
import com.moonlit.logfaces.server.vo.RepositoryEntryVO;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.rmi.RemoteException;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;

public class FetchRepoJob
extends Job {
    private IProgressMonitor monitor;
    private RepositoryModel repo = RepositoryModel.getInstance();
    private static Logger log = LogManager.getLogger(FetchRepoJob.class);

    public FetchRepoJob() {
        super("Getting repository data");
    }

    protected void canceling() {
        if (this.monitor != null) {
            this.monitor.setCanceled(true);
        }
    }

    protected IStatus run(IProgressMonitor monitor) {
        InputStream is;
        int count;
        BufferedReader decoder;
        block10: {
            this.monitor = monitor;
            LfsRemote connection = LfsConnector.getInstance().getConnection();
            if (connection == null) {
                return Status.OK_STATUS;
            }
            String sid = LfsConnector.getInstance().getSid();
            if (!Compatibility.canUseTurboRepo() || Application.isServerMode()) {
                try {
                    final List entries = connection.getRepositoryData(sid);
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            FetchRepoJob.this.repo.reload(entries);
                        }
                    });
                }
                catch (RemoteException e) {
                    Utils.displayPopup("Failed", "Unable to obtain repository data", true);
                }
                return Status.OK_STATUS;
            }
            log.info("fetching repository entries");
            this.repo.clear();
            decoder = null;
            count = 0;
            is = connection.getRepositoryStream(sid);
            if (is != null) break block10;
            IStatus iStatus = Status.OK_STATUS;
            this.repo.setSilent(false);
            this.repo.fireContextChanged();
            IOUtils.closeQuietly(decoder);
            log.info("done repository fetching");
            return iStatus;
        }
        try {
            try {
                JsonEventParser parser = new JsonEventParser();
                monitor.beginTask("Streaming repository data", is.available());
                decoder = new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(is), "UTF-8"));
                this.repo.setSilent(true);
                while (!monitor.isCanceled()) {
                    String line = decoder.readLine();
                    if (line == null) break;
                    RepositoryEntryVO entry = parser.parseRepo(line);
                    if (entry == null) continue;
                    this.repo.addEntry(entry);
                    monitor.subTask("" + ++count);
                }
                FetchRepoHostsJob job = new FetchRepoHostsJob();
                job.setUser(true);
                job.schedule(300L);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                Utils.displayPopup("Failed to get repository data", e.getMessage(), true);
                this.repo.setSilent(false);
                this.repo.fireContextChanged();
                IOUtils.closeQuietly(decoder);
                log.info("done repository fetching");
            }
        }
        catch (Throwable throwable) {
            this.repo.setSilent(false);
            this.repo.fireContextChanged();
            IOUtils.closeQuietly(decoder);
            log.info("done repository fetching");
            throw throwable;
        }
        this.repo.setSilent(false);
        this.repo.fireContextChanged();
        IOUtils.closeQuietly((Reader)decoder);
        log.info("done repository fetching");
        return Status.OK_STATUS;
    }
}

