/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.jobs;

import com.moonlit.logfaces.client.model.RepositoryModel;
import com.moonlit.logfaces.client.net.LfsConnector;
import com.moonlit.logfaces.client.utils.Utils;
import com.moonlit.logfaces.server.remoting.LfsRemote;
import java.io.Reader;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class FetchRepoHostsJob
extends Job {
    private IProgressMonitor monitor;
    private RepositoryModel repo = RepositoryModel.getInstance();
    private static Logger log = LogManager.getLogger(FetchRepoHostsJob.class);

    public FetchRepoHostsJob() {
        super("Getting repository host names");
    }

    protected void canceling() {
        if (this.monitor != null) {
            this.monitor.setCanceled(true);
        }
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.monitor = monitor;
        LfsRemote connection = LfsConnector.getInstance().getConnection();
        if (connection == null) {
            return Status.OK_STATUS;
        }
        log.info("fetching repository hosts");
        this.repo.setSilent(true);
        String sid = LfsConnector.getInstance().getSid();
        Reader decoder = null;
        int count = 0;
        try {
            try {
                List hosts = connection.getRepositoryHosts(sid);
                monitor.beginTask("Streaming repository host names", 1);
                for (String host : hosts) {
                    this.repo.getHosts().addHost(host);
                    monitor.subTask("" + ++count);
                }
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                String message = e.getMessage();
                message = StringUtils.isEmpty((CharSequence)message) && cause != null ? cause.getMessage() : message;
                log.error(e.getMessage(), (Throwable)e);
                Utils.displayPopup("Failed to get repository host names", message, true);
                this.repo.setSilent(false);
                this.repo.fireContextChanged();
                IOUtils.closeQuietly(decoder);
                log.info("done repository hosts fetching");
            }
        }
        finally {
            this.repo.setSilent(false);
            this.repo.fireContextChanged();
            IOUtils.closeQuietly(decoder);
            log.info("done repository hosts fetching");
        }
        return Status.OK_STATUS;
    }
}

