/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.jobs;

import com.moonlit.logfaces.client.jobs.Fetcher;
import com.moonlit.logfaces.client.utils.Utils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class FetchQueryRapidJob
extends Job {
    private Fetcher fetcher;
    private IProgressMonitor monitor;

    public FetchQueryRapidJob(Fetcher fetcher) {
        super("Getting '" + fetcher.getName() + "' data");
        this.fetcher = fetcher;
        this.fetcher.dispose();
    }

    protected void canceling() {
        if (this.monitor != null) {
            this.monitor.setCanceled(true);
        }
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.monitor = monitor;
        try {
            this.getState();
            this.fetcher.run(monitor);
        }
        catch (Exception ex) {
            Utils.displayPopup(this.fetcher.getName(), ex.getMessage(), true);
            return Status.OK_STATUS;
        }
        Throwable error = this.fetcher.getError();
        if (monitor.isCanceled()) {
            if (this.fetcher.getResults().getSize() == 0) {
                return Status.OK_STATUS;
            }
            if (error != null) {
                Utils.displayWarning(this.fetcher.getName(), error.getMessage());
            }
            Utils.displayQueryResults(this.fetcher);
            return Status.OK_STATUS;
        }
        if (this.fetcher.getError() != null) {
            Utils.displayPopup(this.fetcher.getName(), error.getMessage() == null ? error.toString() : error.getMessage(), true);
            return Status.OK_STATUS;
        }
        if (this.fetcher.getResults().isEmpty()) {
            Utils.displayPopup(this.fetcher.getName(), "No data found", false);
            return Status.OK_STATUS;
        }
        return Status.OK_STATUS;
    }
}

