/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.jobs;

import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.model.QueryModel;
import com.moonlit.logfaces.client.model.QueryVO;
import com.moonlit.logfaces.client.net.LfsConnector;
import com.moonlit.logfaces.client.utils.Compatibility;
import com.moonlit.logfaces.client.utils.Utils;
import com.moonlit.logfaces.server.remoting.LfsRemote;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class FetchPinsJob
extends Job {
    private IProgressMonitor monitor;
    private boolean notify;
    private static Logger log = LogManager.getLogger(FetchPinsJob.class);

    public FetchPinsJob(boolean notify) {
        super("Getting pins data");
        this.notify = notify;
    }

    protected void canceling() {
        if (this.monitor != null) {
            this.monitor.setCanceled(true);
        }
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.monitor = monitor;
        LfsRemote connection = LfsConnector.getInstance().getConnection();
        String sid = LfsConnector.getInstance().getSid();
        if (connection == null || sid == null) {
            return Status.OK_STATUS;
        }
        if (!Compatibility.canUsePins() || Application.isServerMode()) {
            return Status.OK_STATUS;
        }
        try {
            List pins = connection.listPins(sid);
            if (pins.isEmpty()) {
                return Status.OK_STATUS;
            }
            for (String pin : pins) {
                QueryModel.getInstance().addQuery(QueryVO.fromXml(pin));
            }
            log.info("updated {} pins", (Object)pins.size());
            if (this.notify) {
                Utils.displayOptionalMessage("Pins updated", "Pin query was just updated and shared with you by another workspace user.\nOpen 'Queries' view for more details.\n\nPin queries are created by workspace users to share important information with others. You can execute pin queries just like any regular query, as well as modify or delete them. Keep in mind that all the changes in pin queries will be shared with workspace users instanteneously.\n", "pins-updated");
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Utils.displayPopup("Failed to get repository data", e.getMessage(), true);
        }
        return Status.OK_STATUS;
    }
}

