/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.jobs;

import com.moonlit.logfaces.client.net.LfsConnector;
import com.moonlit.logfaces.client.utils.Utils;
import com.moonlit.logfaces.server.vo.RepositoryEntryVO;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class DeleteRepositoryDataJob
extends Job {
    private RepositoryEntryVO[] todelete;
    private boolean includeData;

    public DeleteRepositoryDataJob(RepositoryEntryVO[] todelete, boolean includeData) {
        super(includeData ? "Removing repository entries and related log data" : "Removing repository entries");
        this.todelete = todelete;
        this.includeData = includeData;
    }

    protected IStatus run(IProgressMonitor monitor) {
        Eraser eraser = new Eraser();
        try {
            eraser.run(monitor);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (eraser.returnEx != null) {
            Utils.displayPopup("Operation failed", eraser.returnEx.getMessage() == null ? eraser.returnEx.toString() : eraser.returnEx.getMessage(), true);
            return Status.OK_STATUS;
        }
        if (monitor.isCanceled()) {
            return Status.OK_STATUS;
        }
        if (this.includeData) {
            Utils.displayPopup("Done", "Removed " + eraser.deleted + " logging events", false);
        }
        return Status.OK_STATUS;
    }

    class Eraser
    implements IRunnableWithProgress {
        Throwable returnEx;
        long deleted = 0L;

        Eraser() {
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException {
            block2: {
                try {
                    LfsConnector connection = LfsConnector.getInstance();
                    String sid = connection.getSid();
                    this.deleted += (long)connection.getConnection().removeRepositoryData(sid, Arrays.asList(DeleteRepositoryDataJob.this.todelete), DeleteRepositoryDataJob.this.includeData);
                    connection.reloadRepository();
                }
                catch (Throwable e) {
                    this.returnEx = e;
                    Throwable cause = e.getCause();
                    if (cause == null) break block2;
                    this.returnEx = cause;
                }
            }
        }
    }
}

