/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.jobs;

import com.moonlit.logfaces.client.actions.StatusLineContribution;
import com.moonlit.logfaces.client.net.LfsConnector;
import java.rmi.RemoteException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;

public class DatabaseSizeJob
extends Job {
    private StatusLineContribution statusLine;

    public DatabaseSizeJob(StatusLineContribution statusLine) {
        super("Counting database records");
        this.statusLine = statusLine;
    }

    protected IStatus run(IProgressMonitor monitor) {
        Object status = "N/A";
        try {
            LfsConnector connector = LfsConnector.getInstance();
            if (connector.isConnected()) {
                long size = connector.getConnection().getDatabaseSize();
                status = size >= 0L ? size + " rec" : "count disabled";
            }
        }
        catch (RemoteException e) {
            status = "Error";
        }
        this.updateStatusBar((String)status);
        return Status.OK_STATUS;
    }

    private void updateStatusBar(final String text) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                DatabaseSizeJob.this.statusLine.setText(text);
            }
        });
    }
}

