/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.jobs;

import com.google.common.collect.Lists;
import com.moonlit.logfaces.client.model.QueryVO;
import com.moonlit.logfaces.client.net.LfsConnector;
import com.moonlit.logfaces.client.types.TimeRange;
import com.moonlit.logfaces.client.views.DistributionDataListener;
import com.moonlit.logfaces.server.criteria.CriteriaFilter;
import com.moonlit.logfaces.server.criteria.EventAttribute;
import com.moonlit.logfaces.server.criteria.JexlCriteria;
import com.moonlit.logfaces.server.criteria.Operation;
import com.moonlit.logfaces.server.criteria.Rule;
import com.moonlit.logfaces.server.log4j.LfsLevel;
import com.moonlit.logfaces.server.stats.StatCategory;
import com.moonlit.logfaces.server.vo.StatVO;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class DailyDistributionJob
extends Job {
    private Date date;
    private StatCategory category;
    private String domain;
    private String host;
    private DistributionDataListener listener;
    private LfsLevel level;
    private TimeRange rate;
    private static Logger log = LogManager.getLogger(DailyDistributionJob.class);

    public DailyDistributionJob(Date date, StatCategory category, String domain, String host, LfsLevel level, TimeRange rate, DistributionDataListener listener) {
        super("Statisical distributions");
        this.category = category;
        this.date = date;
        this.domain = domain;
        this.host = host;
        this.level = level;
        this.rate = rate;
        this.listener = listener;
    }

    protected IStatus run(IProgressMonitor monitor) {
        JexlCriteria criteria = new JexlCriteria();
        Rule rule = criteria.addRule();
        if (this.domain != null) {
            rule.addCondition((Object)EventAttribute.domainName, (Object)Operation.is, (Object)this.domain);
        }
        if (this.host != null) {
            rule.addCondition((Object)EventAttribute.hostName, (Object)Operation.is, (Object)this.host);
        }
        if (this.category.equals((Object)StatCategory.exception)) {
            rule.addCondition((Object)EventAttribute.thrown, (Object)Operation.is, (Object)Boolean.TRUE).addCondition((Object)EventAttribute.loggerLevel, (Object)Operation.emore, (Object)LfsLevel.WARN.name());
        }
        if (this.category.equals((Object)StatCategory.level)) {
            rule.addCondition((Object)EventAttribute.loggerLevel, (Object)Operation.emore, (Object)this.level.name());
        }
        QueryVO query = new QueryVO();
        query.setTimeRange(TimeRange.CUSTOM_RANGE, this.date.getTime(), this.date.getTime() + 86400000L);
        query.setCriteria((CriteriaFilter)criteria);
        Map<String, Object> params = query.toMap();
        params.put("statcategory", this.category.toString());
        params.put("statrate", this.rate.getRangeAdjusted(query.getToTime() - query.getFromTime(), 120));
        List<StatVO> stats = Lists.newArrayList();
        try {
            LfsConnector connector = LfsConnector.getInstance();
            String sid = connector.getSid();
            stats = connector.getConnection().queryDistribution(sid, params);
            if (stats == null || stats.size() == 0) {
                this.listener.handleDistributionData(null);
                return Status.OK_STATUS;
            }
            for (StatVO vo : stats) {
                if (vo.getCount() == 0.0f) continue;
                this.listener.handleDistributionData(stats);
                return Status.OK_STATUS;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        this.listener.handleDistributionData(null);
        return Status.OK_STATUS;
    }
}

