/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.jobs;

import com.moonlit.logfaces.client.jobs.Fetcher;
import com.moonlit.logfaces.client.model.CountersModel;
import com.moonlit.logfaces.client.model.QueryVO;
import com.moonlit.logfaces.client.model.data.Log4jModel;
import com.moonlit.logfaces.client.model.data.LogDataModel;
import com.moonlit.logfaces.client.net.DashboardClient;
import com.moonlit.logfaces.client.net.LfsConnector;
import com.moonlit.logfaces.server.remoting.LfsRemote;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class CounterDataFetcher
implements Fetcher {
    private LogDataModel model;
    private Throwable returnEx;
    private String dashboardName = DashboardClient.getInstance().getPerspectiveName();
    private int counterID;
    private QueryVO query;

    public CounterDataFetcher(int counterIndex) {
        this.counterID = counterIndex;
        this.model = new Log4jModel();
        this.query = new QueryVO(this.getName());
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException {
        try {
            LfsRemote connection = LfsConnector.getInstance().getConnection();
            String sid = LfsConnector.getInstance().getSid();
            List results = connection.getCounterEvents(sid, this.dashboardName, this.counterID);
            this.model.addAll(results);
        }
        catch (RemoteException e) {
            this.returnEx = e;
        }
    }

    @Override
    public Throwable getError() {
        return this.returnEx;
    }

    @Override
    public LogDataModel getResults() {
        return this.model;
    }

    @Override
    public void dispose() {
        this.model.clear();
    }

    @Override
    public String getName() {
        return CountersModel.getInstance().getCounter(this.counterID).getName();
    }

    @Override
    public QueryVO getQuery() {
        return this.query;
    }

    @Override
    public long getQueryTime() {
        return 0L;
    }

    @Override
    public void setQuery(QueryVO query) {
        this.query = query;
    }
}

