/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.jobs;

import com.google.common.collect.Lists;
import com.moonlit.logfaces.client.dialogs.ListSelectionDialog;
import com.moonlit.logfaces.client.model.ChoiceModel;
import com.moonlit.logfaces.client.model.ChoiceModelItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.StartupThreading;

public class CertificateInstallerJob
extends Job {
    private Shell shell;
    private boolean accepted;
    private String host;
    private String password = "changeit";
    private int port;
    private KeyStore keyStore;
    private File storeFile;
    private List<X509Certificate> chain;
    private Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());

    public CertificateInstallerJob(Shell shell, String host, int port) {
        super("Listing server certificate chain...");
        if (!MessageDialog.openConfirm((Shell)shell, (String)"Confirmation", (String)"Import server certificate to a local ssl trust store?\n\nYou will be presented with a list of certificates available on this server to choose from.\nUse this option when local JVM doesn't have a CA suitable to work with your server.\n\n")) {
            return;
        }
        InputDialog dlg = new InputDialog(shell, "Password", "Local trust store password, leave unchanged if not sure", "changeit", null);
        if (dlg.open() != 0) {
            return;
        }
        this.password = dlg.getValue();
        this.shell = shell;
        this.chain = Lists.newArrayList();
        this.host = host;
        this.port = port;
        this.accepted = true;
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (!this.accepted) {
            return Status.CANCEL_STATUS;
        }
        try {
            if (!this.loadKeyStore()) {
                return Status.CANCEL_STATUS;
            }
            this.listServerCertificates();
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            this.displayPopup("Failed", e.getMessage(), true);
            return Status.CANCEL_STATUS;
        }
        Display.getDefault().asyncExec((Runnable)new StartupThreading.StartupRunnable(){

            public void runWithException() {
                CertificateInstallerJob.this.install();
            }
        });
        return Status.OK_STATUS;
    }

    protected boolean loadKeyStore() throws Exception {
        String storepath = String.format("%s%scacerts", Platform.getConfigurationLocation().getURL().getPath(), File.separator);
        this.storeFile = new File(storepath);
        if (!this.storeFile.isFile()) {
            File dir = new File(String.format("%s%slib%ssecurity", System.getProperty("java.home"), File.separator, File.separator));
            this.storeFile = new File(dir, "jssecacerts");
            if (!this.storeFile.isFile()) {
                this.storeFile = new File(dir, "cacerts");
            }
        }
        try {
            FileInputStream in = new FileInputStream(this.storeFile);
            this.keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            this.keyStore.load(in, this.password.toCharArray());
            ((InputStream)in).close();
            this.storeFile = new File(storepath);
            return true;
        }
        catch (Exception e) {
            throw new Exception(String.format("Unable to open local keystore file%n%s%n%n%s", this.storeFile.getPath(), e.getMessage()));
        }
    }

    protected void listServerCertificates() throws Exception {
        SSLContext context = SSLContext.getInstance("TLS");
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(this.keyStore);
        X509TrustManager defaultTrustManager = (X509TrustManager)tmf.getTrustManagers()[0];
        SavingTrustManager tm = new SavingTrustManager(defaultTrustManager);
        context.init(null, new TrustManager[]{tm}, null);
        SSLSocketFactory factory = context.getSocketFactory();
        this.log.info("listing certificates from {}:{} ", (Object)this.host, (Object)this.port);
        SSLSocket socket = (SSLSocket)factory.createSocket(this.host, this.port);
        socket.setSoTimeout(10000);
        try {
            socket.startHandshake();
            socket.close();
        }
        catch (SSLException sSLException) {
            // empty catch block
        }
        if (tm.chain == null) {
            throw new Exception("Could not obtain server certificate chain");
        }
        this.chain = Lists.newArrayList((Object[])tm.chain);
        this.log.info("got {} certificates", (Object)this.chain.size());
    }

    private void install() {
        ChoiceModel choice = new ChoiceModel(new CertificateModel().build());
        ListSelectionDialog dialog = new ListSelectionDialog(this.shell, "Select server certificates to import", "icons/eclipse3_view.gif", choice);
        dialog.setFilter(false);
        if (dialog.open() != 0) {
            return;
        }
        this.log.info("importing selected certificates");
        try {
            ChoiceModelItem[] items = choice.getItems();
            if (items == null || items.length == 0) {
                return;
            }
            int i = 0;
            while (i < items.length) {
                X509Certificate cert = ((CertificateModel)items[i].getItem()).cert;
                String alias = String.format("%s:%d.%d", this.host, this.port, i + 1);
                this.keyStore.setCertificateEntry(alias, cert);
                ++i;
            }
            FileOutputStream out = new FileOutputStream(this.storeFile);
            this.keyStore.store(out, this.password.toCharArray());
            ((OutputStream)out).close();
            System.setProperty("javax.net.ssl.trustStore", this.storeFile.getPath());
            SSLContext ctx = SSLContext.getInstance("SSL");
            ctx.init(null, null, null);
            HttpsURLConnection.setDefaultSSLSocketFactory(ctx.getSocketFactory());
            this.log.info("certificates imported OK");
            MessageDialog.openInformation((Shell)this.shell, (String)"Done", (String)"Imported OK");
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            MessageDialog.openError((Shell)this.shell, (String)e.getClass().getName(), (String)e.getMessage());
            return;
        }
    }

    public void displayPopup(final String title, final String message, final boolean error) {
        Display.getDefault().asyncExec((Runnable)new StartupThreading.StartupRunnable(){

            public void runWithException() {
                if (!error) {
                    MessageDialog.openInformation((Shell)CertificateInstallerJob.this.shell, (String)title, (String)message);
                } else {
                    MessageDialog.openError((Shell)CertificateInstallerJob.this.shell, (String)title, (String)message);
                }
            }
        });
    }

    class CertificateModel {
        X509Certificate cert;

        CertificateModel() {
        }

        CertificateModel(X509Certificate cert) {
            this.cert = cert;
        }

        public String toString() {
            return String.format("subject: %s, issues: %s", this.cert.getSubjectDN(), this.cert.getIssuerDN());
        }

        List<CertificateModel> build() {
            ArrayList model = Lists.newArrayList();
            for (X509Certificate cert : CertificateInstallerJob.this.chain) {
                model.add(new CertificateModel(cert));
            }
            return model;
        }
    }

    private static class SavingTrustManager
    implements X509TrustManager {
        private final X509TrustManager tm;
        private X509Certificate[] chain;

        SavingTrustManager(X509TrustManager tm) {
            this.tm = tm;
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.chain = chain;
            this.tm.checkServerTrusted(chain, authType);
        }
    }
}

