/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.jobs;

import com.moonlit.logfaces.client.model.SourceIndexModel;
import com.moonlit.logfaces.client.model.SourceMappingModel;
import com.moonlit.logfaces.client.model.UrlVO;
import com.moonlit.logfaces.client.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.DirectoryWalker;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.HiddenFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.OrFileFilter;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class BuildFileIndexesJob
extends Job {
    private IProgressMonitor monitor;
    private boolean confirm;

    public BuildFileIndexesJob(boolean confirm) {
        super("Building source file indexes");
        this.confirm = confirm;
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.monitor = monitor;
        List<File> index = this.buildIndex();
        if (this.confirm && index == null) {
            Utils.displayWarning("No source directories", "Please first specify source directories in Preferences/Files section");
            return Status.OK_STATUS;
        }
        if (this.confirm && index.size() == 0) {
            Utils.displayWarning("Nothing found", "No source files found in specified sourse locations, pleas check out Preferences/Files section");
            return Status.OK_STATUS;
        }
        if (this.confirm) {
            Utils.displayPopup("Indexed", "Indexed " + index.size() + " source files", false);
        }
        return Status.OK_STATUS;
    }

    private List<File> buildIndex() {
        ArrayList<File> results = new ArrayList<File>();
        List<UrlVO> locations = SourceMappingModel.getInstance().getDirs();
        if (locations.isEmpty()) {
            return results;
        }
        this.monitor.beginTask("indexing", locations.size());
        IOFileFilter dirFilter = FileFilterUtils.andFileFilter((IOFileFilter)FileFilterUtils.directoryFileFilter(), (IOFileFilter)HiddenFileFilter.VISIBLE);
        ArrayList<IOFileFilter> suffixFilters = new ArrayList<IOFileFilter>();
        suffixFilters.add(FileFilterUtils.suffixFileFilter((String)".java"));
        suffixFilters.add(FileFilterUtils.suffixFileFilter((String)".cpp"));
        suffixFilters.add(FileFilterUtils.suffixFileFilter((String)".c"));
        suffixFilters.add(FileFilterUtils.suffixFileFilter((String)".cs"));
        suffixFilters.add(FileFilterUtils.suffixFileFilter((String)".scala"));
        OrFileFilter fileFilter = new OrFileFilter(suffixFilters);
        SourceDirectoryWalker walker = new SourceDirectoryWalker(dirFilter, (IOFileFilter)fileFilter);
        walker.walk(locations, results);
        SourceIndexModel.getInstance().init(results);
        return results;
    }

    class SourceDirectoryWalker
    extends DirectoryWalker {
        SourceDirectoryWalker(IOFileFilter dirFilter, IOFileFilter fileFilter) {
            super(dirFilter, fileFilter, -1);
        }

        protected void handleFile(File file, int depth, Collection results) {
            results.add(file);
        }

        public void walk(List<UrlVO> locations, Collection results) {
            int i = 0;
            for (UrlVO location : locations) {
                try {
                    BuildFileIndexesJob.this.monitor.subTask(location.getUrl());
                    this.walk(new File(location.getUrl()), results);
                    BuildFileIndexesJob.this.monitor.worked(++i);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

