/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.jobs;

import com.moonlit.logfaces.client.jobs.Saver;
import com.moonlit.logfaces.client.model.QueryVO;
import com.moonlit.logfaces.client.net.LfsConnector;
import com.moonlit.logfaces.client.types.FileFormat;
import com.moonlit.logfaces.server.core.LogEvent;
import com.moonlit.logfaces.server.remoting.LfsRemote;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.IProgressMonitor;

public class BinaryQuerySaver
implements Saver {
    private Throwable error;
    private long fetchced = 0L;
    private QueryVO query;
    private String fileName;

    public BinaryQuerySaver(QueryVO query, String fileName) {
        this.query = query;
        this.fileName = fileName;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException {
        List results;
        long start;
        ObjectOutputStream outputStream;
        String queryName;
        String sid;
        LfsRemote lfs;
        block15: {
            lfs = LfsConnector.getInstance().getConnection();
            sid = LfsConnector.getInstance().getSid();
            queryName = this.query.getName();
            monitor.beginTask("Retrieving data..", this.query.getLimit());
            outputStream = null;
            start = System.currentTimeMillis();
            outputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.fileName, false)));
            results = lfs.queryBegin(sid, queryName, this.query.toMap(), 500, -1);
            if (results != null) break block15;
            monitor.setCanceled(true);
            IOUtils.closeQuietly((OutputStream)outputStream);
            try {
                lfs.queryEnd(sid, queryName);
            }
            catch (Exception e) {
                this.error = e;
                monitor.setCanceled(true);
            }
            return;
        }
        try {
            try {
                while (results != null) {
                    for (LogEvent event : results) {
                        outputStream.writeObject(event);
                    }
                    outputStream.flush();
                    outputStream.reset();
                    this.fetchced += (long)results.size();
                    monitor.subTask("fetched: " + this.fetchced + " records, avg. speed: " + this.fetchced * 1000L / (System.currentTimeMillis() - start) + " rec/sec");
                    monitor.worked(results.size());
                    results = lfs.queryNext(sid, queryName);
                    if (!monitor.isCanceled()) continue;
                    break;
                }
            }
            catch (Exception ex) {
                this.error = ex;
                monitor.setCanceled(true);
                IOUtils.closeQuietly(outputStream);
                try {
                    lfs.queryEnd(sid, queryName);
                }
                catch (Exception e) {
                    this.error = e;
                    monitor.setCanceled(true);
                }
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(outputStream);
            try {
                lfs.queryEnd(sid, queryName);
            }
            catch (Exception e) {
                this.error = e;
                monitor.setCanceled(true);
            }
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
        try {
            lfs.queryEnd(sid, queryName);
        }
        catch (Exception e) {
            this.error = e;
            monitor.setCanceled(true);
        }
    }

    @Override
    public Throwable getError() {
        return this.error;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public FileFormat getFormat() {
        return FileFormat.binary;
    }

    @Override
    public String getName() {
        return this.query.getName();
    }

    @Override
    public long getNofFetched() {
        return this.fetchced;
    }
}

