/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.jobs;

import com.moonlit.logfaces.client.jobs.Importer;
import com.moonlit.logfaces.client.net.LfsConnector;
import com.moonlit.logfaces.server.core.LogEvent;
import com.moonlit.logfaces.server.remoting.LfsRemote;
import com.moonlit.logfaces.server.vo.LoggingEventVO;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.IProgressMonitor;

public class BinaryImporter
implements Importer {
    private Throwable lastError;
    private long imported = 0L;
    private long failed = 0L;
    private File file;
    private String domain;

    public BinaryImporter(File file, String domain) {
        this.file = file;
        this.domain = domain;
    }

    @Override
    public long getImported() {
        return this.imported;
    }

    @Override
    public long getFailed() {
        return this.failed;
    }

    @Override
    public Throwable getLastError() {
        return this.lastError;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException {
        block12: {
            monitor.beginTask("Importing data..", 100);
            ArrayList<LogEvent> list = new ArrayList<LogEvent>();
            ObjectInputStream is = null;
            LogEvent event = null;
            try {
                try {
                    LfsRemote lfs = LfsConnector.getInstance().getConnection();
                    String sid = LfsConnector.getInstance().getSid();
                    is = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.file)));
                    long start = System.currentTimeMillis();
                    while (!monitor.isCanceled()) {
                        try {
                            event = (LogEvent)is.readObject();
                            if (event == null) {
                            }
                        }
                        catch (EOFException e) {}
                        break;
                        if (this.domain != null && event instanceof LoggingEventVO) {
                            ((LoggingEventVO)event).setDomainName(this.domain);
                        }
                        list.add(event);
                        if (list.size() <= 100) continue;
                        lfs.importData(sid, list);
                        this.imported += (long)list.size();
                        list.clear();
                        monitor.subTask("imported: " + this.imported + " records, avg. speed: " + this.imported * 1000L / (System.currentTimeMillis() - start) + " rec/sec");
                        monitor.worked((int)this.imported);
                    }
                    if (list.size() > 0) {
                        lfs.importData(sid, list);
                        this.imported += (long)list.size();
                        list.clear();
                        monitor.subTask("imported so far: " + this.imported + " records");
                        monitor.worked((int)this.imported);
                    }
                }
                catch (Throwable e) {
                    this.lastError = e;
                    Throwable cause = e.getCause();
                    if (cause != null) {
                        this.lastError = cause;
                    }
                    IOUtils.closeQuietly(is);
                    break block12;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)is);
        }
    }
}

