/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.jobs;

import com.google.common.collect.Lists;
import com.moonlit.logfaces.client.net.LfsConnector;
import com.moonlit.logfaces.client.utils.Utils;
import com.moonlit.logfaces.server.vo.AlertVO;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;

public class AckAlertsJob
extends Job {
    private List<Long> aids = Lists.newArrayList();
    private Runnable callback;
    private static Logger log = LogManager.getLogger(AckAlertsJob.class);

    public AckAlertsJob(Runnable callback) {
        super("Acknowledge all alerts");
        this.callback = callback;
        this.setUser(true);
    }

    public AckAlertsJob(AlertVO alert, Runnable callback) {
        super("Acknowledge selected alerts");
        if (alert != null) {
            this.aids.add(alert.getTime());
        }
        this.callback = callback;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            LfsConnector connector = LfsConnector.getInstance();
            if (connector.isConnected()) {
                connector.ackAlerts(this.aids);
                log.info("acknowledged {} alert(s)", this.aids.isEmpty() ? "all" : Integer.valueOf(this.aids.size()));
                if (this.callback != null) {
                    Display.getDefault().asyncExec(this.callback);
                }
            }
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            Utils.displayException("AckAlertsJob", "Unable to acknowledge alert", ex.getCause() != null ? ex.getCause() : ex);
        }
        return Status.OK_STATUS;
    }
}

