/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.gis;

import com.google.common.collect.Maps;
import com.moonlit.logfaces.client.types.LfcEvent;
import com.moonlit.logfaces.server.util.LfsEventBus;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolTip;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.widgets.Display;
import org.jxmapviewer.viewer.DefaultWaypoint;
import org.jxmapviewer.viewer.GeoPosition;

public class GisLocation
extends DefaultWaypoint {
    private Map<String, Object> data;
    private JButton button;

    public GisLocation() {
        super(new GeoPosition(52.52168137088466, 13.409518136365868));
        this.data = Maps.newHashMap();
        this.data.put("ip", "unknown");
    }

    public GisLocation(Map<String, Object> data) {
        super(new GeoPosition(Double.parseDouble(data.get("lat").toString()), Double.parseDouble(data.get("lon").toString())));
        this.data = data;
    }

    public boolean equals(Object o) {
        if (!(o instanceof GisLocation)) {
            return false;
        }
        GisLocation other = (GisLocation)((Object)o);
        return this.getPosition().equals((Object)other.getPosition());
    }

    public String getIp() {
        return this.data.containsKey("ip") ? this.data.get("ip").toString() : "unknown";
    }

    public JButton getButton() {
        if (this.button == null) {
            this.makeButton();
        }
        return this.button;
    }

    public String getTooltip() {
        StringBuffer buff = new StringBuffer();
        buff.append("<html>");
        for (String key : this.data.keySet()) {
            buff.append(String.format("%s : %s<br>", key, this.data.get(key)));
        }
        return buff.toString();
    }

    private void makeButton() {
        this.button = new JButton(this.getIp()){

            @Override
            public JToolTip createToolTip() {
                JToolTip tip = super.createToolTip();
                tip.setSize(200, 300);
                tip.setBackground(new Color(244, 247, 247));
                tip.setForeground(Color.BLACK);
                return tip;
            }
        };
        this.button.setSize(34, 34);
        this.button.setPreferredSize(new Dimension(34, 34));
        this.button.addMouseListener(new ThisMouseListener());
        this.button.setVisible(true);
        this.button.setFocusable(true);
        this.button.setBorderPainted(false);
        this.button.setBorder(null);
        this.button.setToolTipText(this.getTooltip());
        this.button.setMargin(new Insets(0, 0, 0, 0));
        this.button.setContentAreaFilled(false);
        this.button.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons/pin-red.png")));
    }

    private class ThisMouseListener
    implements MouseListener {
        private ThisMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Display.getDefault().asyncExec(() -> LfsEventBus.getInstance().post((Object)LfcEvent.gis(GisLocation.this, this.isRightClick(e))));
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            Display.getDefault().asyncExec(() -> GisLocation.this.button.grabFocus());
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        public boolean isRightClick(MouseEvent e) {
            return e.getButton() == 3 || Util.isMac() && (e.getModifiersEx() & 0x80) != 0 && (e.getModifiersEx() & 0x80) != 0;
        }
    }
}

