/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.gis;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.moonlit.logfaces.client.Persistent;
import com.moonlit.logfaces.client.gis.GisLocation;
import com.moonlit.logfaces.client.model.PluginsDelegate;
import com.moonlit.logfaces.server.core.LogEvent;
import com.moonlit.logfaces.server.core.LogFacesPlugin;
import java.io.File;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IMemento;

public class GIS
implements Persistent {
    private static GIS instance;
    public static final String PLUGIN_NAME = "IP2Geolocation converter";
    private Logger log = LogManager.getLogger(this.getClass());
    private Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private double lastLat = 52.52168137088466;
    private double lastLon = 13.409518136365868;
    private int lastZoom = 15;

    private GIS() {
    }

    public static GIS getInstance() {
        if (instance == null) {
            instance = new GIS();
        }
        return instance;
    }

    @Override
    public void load(IMemento parent) {
        IMemento memento = parent.getChild("gis");
        if (memento != null) {
            this.lastZoom = memento.getInteger("zoom");
            this.lastLat = memento.getFloat("lat").floatValue();
            this.lastLon = memento.getFloat("lon").floatValue();
        }
        this.getPlugin();
    }

    @Override
    public void save(IMemento parent) {
        IMemento memento = parent.createChild("gis");
        memento.putInteger("zoom", this.lastZoom);
        memento.putFloat("lat", (float)this.lastLat);
        memento.putFloat("lon", (float)this.lastLon);
    }

    public void savePosition(double lat, double lon, int zoom) {
        this.lastLat = lat;
        this.lastLon = lon;
        this.lastZoom = zoom;
    }

    public boolean isEnabled() {
        return this.getPlugin() != null;
    }

    public LogFacesPlugin getPlugin() {
        LogFacesPlugin plugin = PluginsDelegate.getInstance().getPlugin(PLUGIN_NAME);
        if (plugin == null) {
            try {
                File pfile = new File(String.format("%s/temp/IpApi.groovy", Platform.getConfigurationLocation().getURL().getPath()));
                FileUtils.copyInputStreamToFile((InputStream)GIS.class.getResourceAsStream("IpApi.groovy"), (File)pfile);
                ArrayList files = Lists.newArrayList();
                files.add(pfile);
                PluginsDelegate.getInstance().addPlugin(files);
                FileUtils.deleteQuietly((File)pfile);
            }
            catch (Exception e) {
                this.log.error("failed adding gis plugin", (Throwable)e);
            }
        }
        return plugin;
    }

    public GisLocation getDefaultLocation() {
        LogFacesPlugin plugin = this.getPlugin();
        if (plugin == null) {
            return new GisLocation();
        }
        try {
            Object response = plugin.handleEvents(null, null);
            Map data = (Map)this.gson.fromJson(response.toString(), Map.class);
            return new GisLocation(data);
        }
        catch (Exception e) {
            return new GisLocation();
        }
    }

    public Set<GisLocation> resolve(Collection<String> ips, boolean refresh) {
        HashSet locations = Sets.newHashSet();
        LogFacesPlugin plugin = this.getPlugin();
        if (plugin == null) {
            return locations;
        }
        for (String ip : Lists.newArrayList(ips)) {
            try {
                InetAddress a = InetAddress.getByName(ip);
                if (!a.isSiteLocalAddress() && !a.isLoopbackAddress() && !a.isAnyLocalAddress() && !a.isLinkLocalAddress()) continue;
                ips.remove(ip);
            }
            catch (Exception a) {
                // empty catch block
            }
        }
        try {
            HashMap args = Maps.newHashMap();
            if (refresh) {
                args.put("refresh", "true");
            }
            args.put("ips", StringUtils.join(ips, (String)","));
            List list = (List)plugin.handleEvents(null, (Map)args);
            for (String string : list) {
                Map data = (Map)this.gson.fromJson(string, Map.class);
                locations.add(new GisLocation(data));
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return locations;
    }

    public Set<GisLocation> resolve(List<LogEvent> model, boolean refresh) {
        HashSet locations = Sets.newHashSet();
        LogFacesPlugin plugin = this.getPlugin();
        if (plugin == null) {
            return locations;
        }
        try {
            HashMap args = Maps.newHashMap();
            if (refresh) {
                args.put("refresh", "true");
            }
            plugin.handleEvents(model, (Map)args);
            for (LogEvent event : model) {
                List<GisLocation> list = this.event2locations(event);
                locations.addAll(list);
            }
            return locations;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return locations;
        }
    }

    public List<GisLocation> event2locations(LogEvent event) {
        ArrayList locations = Lists.newArrayList();
        try {
            String string = (String)event.getProperties().get("gis.location");
            if (string != null) {
                List data = (List)this.gson.fromJson(string, List.class);
                for (Map location : data) {
                    locations.add(new GisLocation(location));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return locations;
    }

    public double getLastLat() {
        return this.lastLat;
    }

    public void setLastLat(double lastLat) {
        this.lastLat = lastLat;
    }

    public double getLastLon() {
        return this.lastLon;
    }

    public void setLastLon(double lastLon) {
        this.lastLon = lastLon;
    }

    public int getLastZoom() {
        return this.lastZoom;
    }

    public void setLastZoom(int lastZoom) {
        this.lastZoom = lastZoom;
    }
}

