/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.embedded;

import com.google.common.collect.Sets;
import com.moonlit.logfaces.client.model.RepositoryModel;
import com.moonlit.logfaces.server.core.LogEvent;
import com.moonlit.logfaces.server.perspectives.LogPerspective;
import com.moonlit.logfaces.server.receivers.Router;
import com.moonlit.logfaces.server.vo.RepositoryEntryVO;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.eclipse.core.runtime.Platform;

public class RepoPerspective
extends LogPerspective {
    private static RepoPerspective instance;
    private static Logger log;

    static {
        log = LogManager.getLogger(RepoPerspective.class);
    }

    public static RepoPerspective getInstance() {
        if (instance == null) {
            instance = new RepoPerspective();
        }
        return instance;
    }

    private RepoPerspective() {
        super("repository");
    }

    public void initialize() throws Exception {
        this.producer = Router.getInstance();
        RepositoryModel model = RepositoryModel.getInstance();
        Set<RepositoryEntryVO> repo = this.loadEntriesFromFile();
        for (RepositoryEntryVO vo : repo) {
            model.addEntry(vo);
        }
        this.resume();
    }

    public Set<RepositoryEntryVO> loadEntriesFromFile() {
        HashSet ret = Sets.newHashSet();
        File file = new File(Platform.getConfigurationLocation().getURL().getPath() + "/repo.xml");
        if (!file.exists()) {
            return ret;
        }
        try {
            Document doc = new SAXReader().read((InputStream)new FileInputStream(file));
            for (Node node : doc.getRootElement().selectNodes("entry")) {
                Element element = (Element)node;
                RepositoryEntryVO vo = new RepositoryEntryVO();
                vo.setDomainName(element.attributeValue("domainName"));
                vo.setHostName(element.attributeValue("hostName"));
                vo.setLoggerName(element.attributeValue("loggerName"));
                ret.add(vo);
            }
        }
        catch (Throwable ex) {
            log.error(ex.getMessage(), ex);
        }
        return ret;
    }

    public void terminate() {
        try {
            String file = Platform.getConfigurationLocation().getURL().getPath() + "/repo.xml";
            Document doc = DocumentHelper.createDocument();
            Element root = doc.addElement("repository");
            Set<RepositoryEntryVO> entries = RepositoryModel.getInstance().getRepositoryData();
            for (RepositoryEntryVO vo : entries) {
                root.addElement("entry").addAttribute("domainName", vo.getDomainName()).addAttribute("hostName", vo.getHostName()).addAttribute("loggerName", vo.getLoggerName());
            }
            XMLWriter writer = new XMLWriter((Writer)new FileWriter(file), OutputFormat.createPrettyPrint());
            writer.write(doc);
            writer.close();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        super.terminate();
    }

    public boolean assertEvent(LogEvent event) {
        return true;
    }

    public void dispatchEvent(LogEvent event) {
        RepositoryEntryVO vo = new RepositoryEntryVO(event);
        RepositoryModel.getInstance().addEntry(vo);
    }
}

