/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.embedded;

import com.moonlit.logfaces.client.embedded.LicenseHandler;
import com.moonlit.logfaces.server.lic.LicenseType;
import de.schlichtherle.license.LicenseContent;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class LicenseManager {
    private static LicenseManager instance;
    private LicenseHandler licenseHandler = new LicenseHandler();
    private LicenseContent licenseContent;

    private LicenseManager() {
    }

    public static LicenseManager getInstance() {
        if (instance == null) {
            instance = new LicenseManager();
        }
        return instance;
    }

    public void verifyLicense() throws Exception {
        this.licenseContent = this.licenseHandler.verifyLicense();
    }

    public String installLicense(String fileName) throws Exception {
        this.licenseHandler.verifyLicense(fileName);
        this.licenseContent = this.licenseHandler.installLicense(fileName);
        return this.getLicenseContentString();
    }

    public String getLicenseContentString() {
        if (this.licenseContent == null) {
            return "license not installed";
        }
        SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
        String display = "license id   : " + ((Properties)this.licenseContent.getExtra()).getProperty("id") + "\nissued for   : " + String.valueOf(this.licenseContent.getHolder()) + "\nlicense type : " + ((Properties)this.licenseContent.getExtra()).getProperty("licenseType") + "\nissued on    : " + formatter.format(this.licenseContent.getIssued()) + "\nvalid until  : " + (this.licenseContent.getNotAfter() == null ? "unlimited" : formatter.format(this.licenseContent.getNotAfter())) + "\n";
        return display;
    }

    public Map<String, String> getLicenseInfo() throws Exception {
        if (this.licenseContent == null) {
            throw new Exception("no license");
        }
        HashMap<String, String> info = new HashMap<String, String>();
        SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
        info.put("expirationDate", this.licenseContent.getNotAfter() == null ? "unlimited" : formatter.format(this.licenseContent.getNotAfter()));
        info.put("issueDate", formatter.format(this.licenseContent.getIssued()));
        info.put("licenseType", ((Properties)this.licenseContent.getExtra()).getProperty("licenseType"));
        info.put("licenseHolder", this.licenseContent.getHolder().toString());
        return info;
    }

    public LicenseType getLicenseType() {
        if (this.licenseContent == null) {
            return LicenseType.unknown;
        }
        String str = ((Properties)this.licenseContent.getExtra()).getProperty("licenseType");
        return LicenseType.toLicenseType((String)str);
    }

    public boolean isTrial() {
        return this.getLicenseType() == LicenseType.trial;
    }

    public int getNofApplicationsAllowed() {
        String str;
        block3: {
            try {
                str = ((Properties)this.licenseContent.getExtra()).getProperty("nofApplications");
                if (str != null) break block3;
                return Integer.MAX_VALUE;
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return Integer.parseInt(str);
    }
}

