/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.embedded;

import com.moonlit.logfaces.server.lic.LicenseType;
import com.moonlit.logfaces.server.util.Revision;
import de.schlichtherle.license.CipherParam;
import de.schlichtherle.license.KeyStoreParam;
import de.schlichtherle.license.LicenseContent;
import de.schlichtherle.license.ftp.LicenseManager;
import de.schlichtherle.license.ftp.LicenseParam;
import de.schlichtherle.util.ObfuscatedString;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import java.util.prefs.Preferences;
import javax.security.auth.x500.X500Principal;

public class LicenseHandler {
    private static final String FTPC = new ObfuscatedString(new long[]{7798136176096419223L, -4613713050546158248L}).toString();

    public LicenseType getLicenseType(LicenseContent licenseContent) {
        if (licenseContent == null) {
            return LicenseType.unknown;
        }
        String str = ((Properties)licenseContent.getExtra()).getProperty("licenseType");
        return LicenseType.toLicenseType((String)str);
    }

    public boolean isTrial(LicenseContent licenseContent) {
        return this.getLicenseType(licenseContent) == LicenseType.trial;
    }

    public LicenseContent installLicense(String fileName) throws Exception {
        MyLicenseParam licenceParam = new MyLicenseParam();
        LicenseManager lm = new LicenseManager((LicenseParam)licenceParam);
        File licenseFile = new File(fileName);
        return lm.install(licenseFile);
    }

    public LicenseContent verifyLicense() throws Exception {
        MyLicenseParam licenceParam = new MyLicenseParam();
        LicenseManager lm = new LicenseManager((LicenseParam)licenceParam);
        LicenseContent content = lm.verify();
        this.checkExpiration(content);
        LicenseType type = this.getLicenseType(content);
        if (type == LicenseType.unknown) {
            throw new Exception("invalid license");
        }
        return content;
    }

    public LicenseContent verifyLicense(String fileName) throws Exception {
        int b;
        MyLicenseParam licenceParam = new MyLicenseParam();
        LicenseManager lm = new LicenseManager((LicenseParam)licenceParam);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        FileInputStream is = new FileInputStream(new File(fileName));
        while ((b = ((InputStream)is).read()) != -1) {
            os.write(b);
        }
        ((InputStream)is).close();
        LicenseContent content = lm.verify(os.toByteArray());
        this.checkExpiration(content);
        LicenseType type = this.getLicenseType(content);
        if (type == LicenseType.unknown) {
            throw new Exception("invalid license");
        }
        return content;
    }

    public void checkExpiration(LicenseContent content) throws Exception {
        Date licenseIssueDate = content.getIssued();
        Revision revision = Revision.getRevision();
        if (revision.getDate() == 0L || licenseIssueDate == null) {
            return;
        }
        if (this.getMaintPeriodExpiration(content).getTime() < revision.getDate()) {
            String message = String.format("This license maintenance plan doesn't cover v%s. Please consider upgrading the maintenance plan or downgrade to previous version. Contact http://www.logfaces.com for more details.", revision);
            throw new Exception(message);
        }
    }

    public Date getMaintPeriodExpiration(LicenseContent licenseContent) {
        Calendar calendar = Calendar.getInstance();
        try {
            if (this.isTrial(licenseContent)) {
                calendar.setTime(licenseContent.getNotAfter());
                return calendar.getTime();
            }
            Properties props = (Properties)licenseContent.getExtra();
            if (props.containsKey("maintPlanExp")) {
                String maintPlanExp = props.getProperty("maintPlanExp");
                return new SimpleDateFormat("ddMMyy").parse(maintPlanExp);
            }
            String str = props.getProperty("maintPlan", "12");
            int months = Integer.parseInt(str);
            calendar.setTime(licenseContent.getIssued());
            calendar.set(2, calendar.get(2) + months);
            return calendar.getTime();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void uninstallLicense() throws Exception {
        MyLicenseParam licenceParam = new MyLicenseParam();
        LicenseManager lm = new LicenseManager((LicenseParam)licenceParam);
        lm.uninstall();
    }

    class MyCipherParam
    implements CipherParam {
        MyCipherParam() {
        }

        public String getKeyPwd() {
            return new ObfuscatedString(new long[]{-5387810761414982367L, 6649496129779446487L}).toString();
        }
    }

    class MyFtpKeyStoreParam
    implements KeyStoreParam {
        MyFtpKeyStoreParam() {
        }

        public InputStream getStream() throws IOException {
            InputStream in = this.getClass().getResourceAsStream("/ftp");
            if (in == null) {
                throw new FileNotFoundException("ftp");
            }
            return in;
        }

        public String getAlias() {
            return new ObfuscatedString(new long[]{7170291531820358342L, -7250440230225945923L, 4306340651228214429L}).toString();
        }

        public String getStorePwd() {
            return new ObfuscatedString(new long[]{3633940410360929165L, -8768471576165587521L}).toString();
        }

        public String getKeyPwd() {
            return new ObfuscatedString(new long[]{3633940410360929165L, -8768471576165587521L}).toString();
        }
    }

    class MyKeyStoreParam
    implements KeyStoreParam {
        MyKeyStoreParam() {
        }

        public InputStream getStream() throws IOException {
            InputStream in = this.getClass().getResourceAsStream("/store");
            if (in == null) {
                throw new FileNotFoundException("store");
            }
            return in;
        }

        public String getAlias() {
            return new ObfuscatedString(new long[]{-2370429017662704103L, 2290541973263104350L, 333119893702159546L}).toString();
        }

        public String getStorePwd() {
            return new ObfuscatedString(new long[]{3633940410360929165L, -8768471576165587521L}).toString();
        }

        public String getKeyPwd() {
            return null;
        }
    }

    class MyLicenseParam
    implements LicenseParam {
        MyLicenseParam() {
        }

        public LicenseContent createFTPLicenseContent() {
            try {
                LicenseContent content = new LicenseContent();
                X500Principal holder = new X500Principal("CN=" + InetAddress.getLocalHost().getHostName());
                content.setHolder(holder);
                content.setIssued(new Date());
                Properties props = new Properties();
                props.setProperty("licenseType", "trial");
                props.setProperty("id", "n/a");
                content.setExtra((Object)props);
                return content;
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
                return null;
            }
        }

        public void ftpGranted(LicenseContent content) {
        }

        public int getFTPDays() {
            return 10;
        }

        public KeyStoreParam getFTPKeyStoreParam() {
            return new MyFtpKeyStoreParam();
        }

        public boolean isFTPEligible() {
            return Preferences.systemRoot().get(FTPC, "").equals("");
        }

        public void removeFTPEligibility() {
            Preferences.systemRoot().put(FTPC, "" + System.currentTimeMillis());
        }

        public String getSubject() {
            return new ObfuscatedString(new long[]{6291872870570680018L, 1973023251970324176L}).toString();
        }

        public Preferences getPreferences() {
            return Preferences.userNodeForPackage(LicenseHandler.class);
        }

        public KeyStoreParam getKeyStoreParam() {
            return new MyKeyStoreParam();
        }

        public CipherParam getCipherParam() {
            return new MyCipherParam();
        }
    }
}

