/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.embedded;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.embedded.EmbeddedHub;
import com.moonlit.logfaces.client.embedded.EmbeddedPerspective;
import com.moonlit.logfaces.client.embedded.LicenseManager;
import com.moonlit.logfaces.client.embedded.RepoPerspective;
import com.moonlit.logfaces.client.model.data.LogEventListener;
import com.moonlit.logfaces.server.conf.MdcMap;
import com.moonlit.logfaces.server.core.LogEvent;
import com.moonlit.logfaces.server.criteria.CriteriaFilter;
import com.moonlit.logfaces.server.perspectives.LogPerspective;
import com.moonlit.logfaces.server.receivers.Router;
import com.moonlit.logfaces.server.remoting.LfsRemote;
import com.moonlit.logfaces.server.util.Revision;
import com.moonlit.logfaces.server.vo.AlertVO;
import com.moonlit.logfaces.server.vo.RepositoryEntryVO;
import com.moonlit.logfaces.server.vo.StatVO;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public class LfsEmbeddedSession
implements LfsRemote,
IEclipsePreferences.IPreferenceChangeListener {
    Map<String, EmbeddedPerspective> perspectives = new TreeMap<String, EmbeddedPerspective>();
    IProgressMonitor initMonitor;
    private static Logger log = LogManager.getLogger(LfsEmbeddedSession.class);

    public LfsEmbeddedSession(IProgressMonitor monitor) {
        this.initMonitor = monitor;
    }

    public void setListener(String perspective, LogEventListener listener) {
        LogPerspective p = this.perspectives.get(perspective);
        if (p != null) {
            ((EmbeddedPerspective)p).setListener(listener);
        }
    }

    public String connect() throws RemoteException {
        try {
            this.initMonitor.subTask("Initializaing hub...");
            EmbeddedHub.getInstance().initialize();
            this.initMonitor.subTask("Initializaing router...");
            Router.getInstance().initialize();
            this.initMonitor.subTask("Setting up repository...");
            RepoPerspective.getInstance().initialize();
            Application.getPrefs().addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
            return "embedded-session";
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
            throw new RemoteException(e.getMessage());
        }
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
    }

    public void disconnect(String sid) throws RemoteException {
        for (LogPerspective logPerspective : this.perspectives.values()) {
            logPerspective.terminate();
        }
        try {
            Application.getPrefs().removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
            RepoPerspective.getInstance().terminate();
            Router.getInstance().terminate();
            EmbeddedHub.getInstance().terminate();
        }
        catch (Throwable throwable) {
            log.error(throwable.getMessage(), throwable);
        }
    }

    public void terminate() throws RemoteException {
    }

    public List<RepositoryEntryVO> getRepositoryData(String sid) throws RemoteException {
        Set<RepositoryEntryVO> ret = RepoPerspective.getInstance().loadEntriesFromFile();
        return new ArrayList<RepositoryEntryVO>(ret);
    }

    public List<String> getRepositoryHosts(String sid) throws RemoteException {
        return Lists.newArrayList();
    }

    public InputStream getRepositoryStream(String sid) throws RemoteException {
        return null;
    }

    public long getSessionTimeout() throws RemoteException {
        return Long.MAX_VALUE;
    }

    public void isAlive(String sid) throws RemoteException {
    }

    public boolean isDatabaseEnabled() throws RemoteException {
        return false;
    }

    public String getDatabaseDialect() throws RemoteException {
        return "UNKNOWN";
    }

    public long getDatabaseSize() throws RemoteException {
        return 0L;
    }

    public Map<Integer, String> getMdcMapping() throws RemoteException {
        MdcMap.clear();
        int i = 0;
        while (i < 10) {
            String value = Application.getPrefs().get(String.format("%s%d", "mdc", i), "");
            MdcMap.put((int)i, (String)value);
            ++i;
        }
        return MdcMap.getMap();
    }

    public void setupPerspective(String sid, String name, CriteriaFilter criteria) throws RemoteException {
        EmbeddedPerspective p = this.perspectives.get(name);
        if (p == null) {
            p = new EmbeddedPerspective(name, criteria);
            this.perspectives.put(name, p);
        }
        p.setCriteria(criteria);
    }

    public void removePerspective(String sid, String name) throws RemoteException {
        EmbeddedPerspective p = this.perspectives.remove(name);
        if (p != null) {
            p.terminate();
        }
    }

    public void activatePerspective(String sid, String name) throws RemoteException {
        if (name == null) {
            throw new RemoteException("null argument is not allowed");
        }
        LogPerspective p = this.perspectives.get(name);
        if (p == null) {
            throw new RemoteException("perspective not found");
        }
        p.resume();
    }

    public void deactivatePerspective(String sid, String name) throws RemoteException {
        if (name == null) {
            throw new RemoteException("null argument is not allowed");
        }
        LogPerspective p = this.perspectives.get(name);
        if (p == null) {
            throw new RemoteException("perspective not found");
        }
        p.pause();
    }

    public List<LogEvent> pollPerspective(String sid, String name, long timeout) throws RemoteException {
        return null;
    }

    public int queryCount(String sid, String name) throws RemoteException {
        return 0;
    }

    public void queryEnd(String sid, String name) throws RemoteException {
    }

    public List<LogEvent> queryFirst(String sid, String name, int pageSize) throws RemoteException {
        return null;
    }

    public List<LogEvent> queryLast(String sid, String name) throws RemoteException {
        return null;
    }

    public List<LogEvent> queryNext(String sid, String name) throws RemoteException {
        return null;
    }

    public List<LogEvent> queryPrev(String sid, String name) throws RemoteException {
        return null;
    }

    public String getRevision() throws RemoteException {
        return Revision.getRevision().toShortString();
    }

    public Map<String, String> getLicenseInfo() throws RemoteException {
        try {
            return LicenseManager.getInstance().getLicenseInfo();
        }
        catch (Exception e) {
            if (e.getMessage().equals("no license")) {
                try {
                    LicenseManager.getInstance().verifyLicense();
                    return LicenseManager.getInstance().getLicenseInfo();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new RemoteException(e.getMessage());
        }
    }

    public String getLicenseString() throws RemoteException {
        return null;
    }

    public List<String> getListOfPerspectives(String sid) throws RemoteException {
        return null;
    }

    public void importData(String sid, List<LogEvent> events) throws RemoteException {
    }

    public int removeRepositoryData(String sid, List<RepositoryEntryVO> entries, boolean includeData) throws RemoteException {
        return 0;
    }

    public void setupCounters(String sid, String name, Map<Integer, CriteriaFilter> settings) throws RemoteException {
    }

    public Map<Integer, Integer> pollCounters(String sid, String name, long timeout) throws RemoteException {
        return null;
    }

    public void resetCounters(String sid, String name) throws RemoteException {
    }

    public List<LogEvent> getCounterEvents(String sid, String name, int counterIndex) throws RemoteException {
        return null;
    }

    public String login(String userName, String password) throws RemoteException {
        return null;
    }

    public boolean isApiEnabled() throws RemoteException {
        return false;
    }

    public Map<Integer, String> getCustomLevels() throws RemoteException {
        return new HashMap<Integer, String>();
    }

    public InputStream downloadWorkspace(String sid, String name) throws RemoteException {
        return null;
    }

    public List<String> listWorkspaces(String sid) throws RemoteException {
        return null;
    }

    public void uploadWorkspace(String sid, String name, boolean overwrite, InputStream data) throws RemoteException {
    }

    public List<LogEvent> queryBegin(String sid, String name, Map<String, Object> params, int pageSize, int maxResults) throws RemoteException {
        return null;
    }

    public InputStream saveQueryToFile(String sid, Map<String, Object> params, String format) throws RemoteException {
        return null;
    }

    public List<StatVO> queryDistribution(String sid, Map<String, Object> params) throws RemoteException {
        return null;
    }

    public String pair(String peerHost) throws RemoteException {
        return null;
    }

    public Set<String> getPairs() throws RemoteException {
        return null;
    }

    public InputStream queryTurbo(String sid, String name, Map<String, Object> params) throws RemoteException {
        return null;
    }

    public Object queryOne(String sid, Object oid, String attribute) throws RemoteException {
        return null;
    }

    public InputStream getPatternLibrary(String sid) throws RemoteException {
        return null;
    }

    public void savePatternLibrary(String sid, InputStream is) throws RemoteException {
    }

    public Map<String, Map<String, String>> getParsers(String sid) {
        return Maps.newHashMap();
    }

    public void uploadConfiguration(boolean restart, InputStream is) throws RemoteException {
    }

    public List<String> listPlugins(String sid) throws RemoteException {
        return Lists.newArrayList();
    }

    public InputStream downloadPlugins(String sid, List<String> names) throws RemoteException {
        return null;
    }

    public List<AlertVO> listAlerts(String sid, long fromTime, long timeout) throws RemoteException {
        return null;
    }

    public void ackAlerts(String sid, List<Long> ids) throws RemoteException {
    }

    public List<String> listPins(String sid) throws RemoteException {
        return null;
    }

    public void addPin(String sid, String pid, String pin) throws RemoteException {
    }

    public void removePin(String sid, String pinID) throws RemoteException {
    }
}

