/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.embedded;

import com.google.common.collect.Lists;
import com.moonlit.logfaces.client.net.ConnectionDetails;
import com.moonlit.logfaces.server.conf.Options;
import com.moonlit.logfaces.server.core.LogReceiver;
import com.moonlit.logfaces.server.core.Protocol;
import com.moonlit.logfaces.server.core.ReceiverHub;
import com.moonlit.logfaces.server.core.ReceiverType;
import com.moonlit.logfaces.server.receivers.SyslogReceiver;
import com.moonlit.logfaces.server.receivers.TcpReceiver;
import com.moonlit.logfaces.server.receivers.UdpReceiver;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EmbeddedHub
implements ReceiverHub {
    private static EmbeddedHub instance;
    private List<LogReceiver> receivers = Lists.newArrayList();
    private boolean initialized;
    private static Logger log;

    static {
        log = LogManager.getLogger(EmbeddedHub.class);
    }

    public static EmbeddedHub getInstance() {
        if (instance == null) {
            instance = new EmbeddedHub();
        }
        return instance;
    }

    private EmbeddedHub() {
    }

    public void initialize() throws Exception {
        Options options;
        TcpReceiver receiver;
        if (this.initialized) {
            return;
        }
        ConnectionDetails details = new ConnectionDetails();
        if (details.isTcpEnabled()) {
            receiver = new TcpReceiver();
            options = new Options();
            options.setProperty("enabled", (Object)true);
            options.setProperty("type", (Object)ReceiverType.log4j.name());
            options.setProperty("protocol", (Object)Protocol.tcp.name());
            options.setProperty("port", (Object)details.getTcpPort());
            options.setProperty("format", (Object)details.getReceiverFormat(true).name());
            receiver.setOptions(options);
            this.receivers.add((LogReceiver)receiver);
        }
        if (details.isTcpSysEnabled()) {
            receiver = new SyslogReceiver();
            options = new Options();
            options.setProperty("enabled", (Object)true);
            options.setProperty("type", (Object)ReceiverType.syslog.name());
            options.setProperty("protocol", (Object)Protocol.tcp.name());
            options.setProperty("port", (Object)details.getTcpSysPort());
            receiver.setOptions(options);
            this.receivers.add((LogReceiver)receiver);
        }
        if (details.isUdpEnabled()) {
            receiver = new UdpReceiver();
            options = new Options();
            options.setProperty("enabled", (Object)true);
            options.setProperty("type", (Object)ReceiverType.log4j.name());
            options.setProperty("protocol", (Object)Protocol.udp.name());
            options.setProperty("port", (Object)details.getUdpPort());
            options.setProperty("format", (Object)details.getReceiverFormat(false).name());
            receiver.setOptions(options);
            this.receivers.add((LogReceiver)receiver);
        }
        if (details.isUdpSysEnabled()) {
            receiver = new SyslogReceiver();
            options = new Options();
            options.setProperty("enabled", (Object)true);
            options.setProperty("type", (Object)ReceiverType.syslog.name());
            options.setProperty("protocol", (Object)Protocol.udp.name());
            options.setProperty("port", (Object)details.getUdpSysPort());
            receiver.setOptions(options);
            this.receivers.add((LogReceiver)receiver);
        }
        this.initialized = true;
    }

    public void terminate() {
        for (LogReceiver receiver : this.receivers) {
            try {
                receiver.shutdown(false);
            }
            catch (RuntimeException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        this.receivers.clear();
        this.initialized = false;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void restart() throws Exception {
        this.terminate();
        this.initialize();
    }

    public int getTotalConnections() {
        int count = 0;
        for (LogReceiver receiver : this.receivers) {
            count += receiver.getNumberOfConnections();
        }
        return count;
    }

    public void setMaxConnections(int maxConnections) {
        for (LogReceiver receiver : this.receivers) {
            receiver.setMaxConnections(maxConnections);
        }
    }

    public List<LogReceiver> getReceivers() {
        return Lists.newArrayList(this.receivers);
    }

    public LogReceiver getReceiver(Object id) {
        for (LogReceiver receiver : this.receivers) {
            if (!receiver.getId().equals(id)) continue;
            return receiver;
        }
        return null;
    }

    public LogReceiver addReceiver(Options options) throws Exception {
        return null;
    }

    public LogReceiver removeReceiver(Object id) {
        return null;
    }

    public void save() throws Exception {
    }

    public List<Options> parseConfig() throws Exception {
        return null;
    }

    public LogReceiver makeReceiver(Options options) throws Exception {
        return null;
    }
}

