/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.editors;

import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.Fontable;
import com.moonlit.logfaces.client.editors.Searchable;
import com.moonlit.logfaces.client.editors.SourceCodeEdiorInput;
import com.moonlit.logfaces.client.model.SearchOptions;
import com.moonlit.logfaces.client.text.JavaLineStyler;
import com.moonlit.logfaces.client.utils.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;

public class SourceCodeEditor
extends EditorPart
implements Fontable,
IPropertyChangeListener,
Searchable {
    public static final String ID = "com.moonlit.logfaces.client.editors.SourceCodeEditor";
    private SourceCodeEdiorInput input;
    private StyledText text;
    private String FONTID = "lfs.font.sources";
    private JavaLineStyler lineStyler;
    private boolean searchActive;

    public void init(IEditorSite site, IEditorInput inp) throws PartInitException {
        this.input = (SourceCodeEdiorInput)inp;
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(inp);
        this.setPartName(inp.getName());
        this.lineStyler = new JavaLineStyler();
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void setFocus() {
        this.text.setCaretOffset(this.text.getOffsetAtLine(this.input.getLineNumber() - 1));
        this.text.setFocus();
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.text = new StyledText(parent, 2818);
        GridData spec = new GridData();
        spec.horizontalAlignment = 4;
        spec.grabExcessHorizontalSpace = true;
        spec.verticalAlignment = 4;
        spec.grabExcessVerticalSpace = true;
        this.text.setLayoutData((Object)spec);
        this.text.addLineStyleListener((LineStyleListener)this.lineStyler);
        this.text.setEditable(false);
        this.text.setFont(Application.getFontRegistry().get(this.FONTID));
        Color bg = Display.getDefault().getSystemColor(1);
        this.text.setBackground(bg);
        this.reload((IEditorInput)this.input);
        PlatformUI.getWorkbench().getThemeManager().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void reload(IEditorInput inp) {
        this.input = (SourceCodeEdiorInput)inp;
        this.showText(this.input.getPath().toFile());
    }

    public void dispose() {
        PlatformUI.getWorkbench().getThemeManager().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    private void showText(File file) {
        String textString;
        if (!file.exists()) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Failed", (String)String.format("File not found: %s", file.getName()));
            return;
        }
        try {
            FileInputStream stream = new FileInputStream(file.getPath());
            try {
                int n;
                BufferedReader in = new BufferedReader(new InputStreamReader(stream));
                char[] readBuffer = new char[2048];
                StringBuffer buffer = new StringBuffer((int)file.length());
                while ((n = in.read(readBuffer)) > 0) {
                    buffer.append(readBuffer, 0, n);
                }
                textString = buffer.toString();
                stream.close();
            }
            catch (IOException e) {
                MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Failed", (String)String.format("%s\n%s", e.getMessage(), file.getName()));
                return;
            }
        }
        catch (FileNotFoundException e) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Failed", (String)String.format("%s\n%s", e.getMessage(), file.getName()));
            return;
        }
        this.text.setData("currentLine", (Object)this.input.getLineNumber());
        this.text.setText(textString);
        this.text.setTopIndex(Math.max(0, this.input.getLineNumber() - 10));
        this.lineStyler.parseBlockComments(textString);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.FONTID.equals(event.getProperty())) {
            this.text.setFont(Application.getFontRegistry().get(this.FONTID));
        }
    }

    @Override
    public boolean findNext(SearchOptions options) {
        int start;
        String what = options.getSearchText();
        if (!StringUtils.hasText(what)) {
            return false;
        }
        String content = this.text.getText();
        int from = content.indexOf(what, start = this.text.getCaretOffset());
        if (from < 0) {
            return false;
        }
        int line = this.text.getLineAtOffset(from);
        this.text.setSelection(from, from + what.length());
        this.text.setTopIndex(Math.max(0, line - 5));
        return true;
    }

    @Override
    public boolean findPrev(SearchOptions options) {
        int start;
        String what = options.getSearchText();
        if (!StringUtils.hasText(what)) {
            return false;
        }
        String content = this.text.getText();
        int from = content.lastIndexOf(what, start = this.text.getCaretOffset() - this.text.getSelectionCount() - 1);
        if (from < 0) {
            return false;
        }
        int line = this.text.getLineAtOffset(from);
        this.text.setSelection(from, from + what.length());
        this.text.setTopIndex(Math.max(0, line - 5));
        return true;
    }

    @Override
    public boolean findAndMark(SearchOptions options) {
        return false;
    }

    @Override
    public void unmark() {
    }

    @Override
    public boolean findAndFilter(SearchOptions options) {
        return false;
    }

    @Override
    public void unfilter() {
    }

    @Override
    public boolean canFindAnnotate() {
        return false;
    }

    @Override
    public boolean isMarked() {
        return false;
    }

    @Override
    public boolean isFiltered() {
        return false;
    }

    @Override
    public boolean isActive() {
        return this.searchActive;
    }

    @Override
    public void setActive(boolean active) {
        this.searchActive = active;
    }

    @Override
    public String getFontID() {
        return this.FONTID;
    }
}

