/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.editors;

import com.google.common.collect.Lists;
import com.moonlit.logfaces.client.editors.LogEditor;
import com.moonlit.logfaces.client.editors.LogView;
import com.moonlit.logfaces.client.editors.Searchable;
import com.moonlit.logfaces.client.model.SearchOptions;
import com.moonlit.logfaces.client.model.data.Annotation;
import com.moonlit.logfaces.client.model.data.LogDataModel;
import java.util.List;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Table;

class SearchAdapter
implements Searchable {
    private LogView view;
    private LogDataModel model;
    private Table table;
    private TableViewer tableViewer;
    private boolean active;
    private boolean filtered;
    private List<Annotation> bookmarks;

    public SearchAdapter(LogView view) {
        this.view = view;
        this.model = view.getModel();
        this.tableViewer = view.getTableViewer();
        this.table = this.tableViewer.getTable();
        this.bookmarks = Lists.newArrayList();
    }

    @Override
    public boolean findAndFilter(SearchOptions options) {
        if (this.filtered) {
            this.unfilter();
            return true;
        }
        this.filtered = true;
        String text = options.getSearchText();
        if (this.model.findAndFilter(text) > 0) {
            this.view.refresh(false);
            return true;
        }
        return false;
    }

    @Override
    public boolean findAndMark(SearchOptions options) {
        if (!this.bookmarks.isEmpty()) {
            this.unmark();
            return true;
        }
        String text = options.getSearchText();
        this.bookmarks = this.model.findAndAnnotate(text);
        if (this.bookmarks.size() == 0) {
            return false;
        }
        this.reveal(this.bookmarks.get(0).getLocation());
        return true;
    }

    @Override
    public void unmark() {
        this.model.removeAnnotation(this.bookmarks);
        this.bookmarks.clear();
    }

    @Override
    public boolean findNext(SearchOptions options) {
        String text = options.getSearchText();
        int index = this.model.find(text, this.table.getSelectionIndex() + 1, true);
        if (index == -1) {
            return false;
        }
        this.reveal(index);
        return true;
    }

    @Override
    public boolean findPrev(SearchOptions options) {
        String text = options.getSearchText();
        int index = this.model.find(text, this.table.getSelectionIndex() - 1, false);
        if (index == -1) {
            return false;
        }
        this.reveal(index);
        return true;
    }

    @Override
    public void unfilter() {
        if (this.filtered) {
            this.view.refresh(true);
        }
        this.filtered = false;
    }

    private void reveal(int index) {
        if (index == -1) {
            return;
        }
        int topIndex = index - 5;
        this.table.setTopIndex(topIndex > 0 ? topIndex : 0);
        this.table.setSelection(index);
        this.tableViewer.setSelection(this.tableViewer.getSelection());
    }

    @Override
    public boolean canFindAnnotate() {
        return !(this.view instanceof LogEditor);
    }

    @Override
    public boolean isMarked() {
        return !this.bookmarks.isEmpty();
    }

    @Override
    public boolean isFiltered() {
        return this.filtered;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }
}

