/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.editors;

import com.moonlit.logfaces.client.ImageHolder;
import com.moonlit.logfaces.client.MainPlugin;
import com.moonlit.logfaces.client.jobs.Fetcher;
import com.moonlit.logfaces.client.jobs.LogFileParser;
import com.moonlit.logfaces.client.model.QueryVO;
import com.moonlit.logfaces.client.types.Direction;
import java.util.TimeZone;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public class QueryResultsInput
implements IEditorInput {
    private QueryVO original;
    private QueryVO query;
    private QueryVO paging;
    private String name;
    private Fetcher fetcher;
    private long queryTime;

    public QueryResultsInput(Fetcher fetcher) {
        this.name = fetcher.getName();
        this.fetcher = fetcher;
        this.original = fetcher.getQuery();
        this.query = fetcher.getQuery();
        this.paging = this.query.clone();
    }

    public QueryResultsInput(QueryVO query) {
        this.original = query;
        this.query = query;
        this.paging = query.clone();
        this.name = query.getName();
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.query.isPin()) {
            return MainPlugin.getImageDescriptor("icons/flag.png");
        }
        if (this.isFile()) {
            return MainPlugin.getImageDescriptor("icons/dashboard.gif");
        }
        return MainPlugin.getImageDescriptor("icons/query.gif");
    }

    public Image getImage() {
        if (this.query.isPin()) {
            return ImageHolder.getInstance().getImage("icons/flag.png");
        }
        if (this.isFile()) {
            return ImageHolder.getInstance().getImage("icons/dashboard.gif");
        }
        return ImageHolder.getInstance().getImage("icons/query.gif");
    }

    public String getName() {
        return this.name;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.name;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public QueryVO getQuery() {
        return this.query;
    }

    public boolean isFile() {
        return this.fetcher != null && this.fetcher instanceof LogFileParser;
    }

    public Fetcher getFetcher() {
        return this.fetcher;
    }

    public void setFetcher(Fetcher fetcher) {
        this.fetcher = fetcher;
    }

    public long getQueryTime() {
        return this.queryTime;
    }

    public void setQueryTime(long queryTime) {
        this.queryTime = queryTime;
    }

    public TimeZone getTimeZone() {
        if (this.query == null) {
            return TimeZone.getDefault();
        }
        return this.query.getTimeZone();
    }

    public void dispose() {
        if (this.fetcher != null) {
            this.fetcher.dispose();
        }
    }

    public void setQuery(QueryVO query) {
        this.query = query;
        this.original = query;
        this.paging = query.clone();
        this.fetcher.setQuery(query);
    }

    public void page(Direction direction) {
        if (direction == Direction.none) {
            this.setQuery(this.original);
            return;
        }
        this.paging.page(direction);
        this.query = this.paging;
        this.fetcher.setQuery(this.query);
    }
}

