/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.editors;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.eventbus.Subscribe;
import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.Columns;
import com.moonlit.logfaces.client.Fontable;
import com.moonlit.logfaces.client.ImageHolder;
import com.moonlit.logfaces.client.actions.BrowseDetailsAction;
import com.moonlit.logfaces.client.actions.ExportQueryAction;
import com.moonlit.logfaces.client.actions.ExportToLogFileAction;
import com.moonlit.logfaces.client.dialogs.ColumnFilterDlg;
import com.moonlit.logfaces.client.dialogs.ColumnsDlg;
import com.moonlit.logfaces.client.dialogs.FindDialog;
import com.moonlit.logfaces.client.dialogs.ListSelectionDialog;
import com.moonlit.logfaces.client.dialogs.QueryDialog;
import com.moonlit.logfaces.client.dialogs.WildCardExpressionDialog;
import com.moonlit.logfaces.client.editors.LogView;
import com.moonlit.logfaces.client.editors.QueryResultsInput;
import com.moonlit.logfaces.client.editors.SearchAdapter;
import com.moonlit.logfaces.client.editors.Searchable;
import com.moonlit.logfaces.client.gis.GisLocation;
import com.moonlit.logfaces.client.jobs.FetchQueryRapidJob;
import com.moonlit.logfaces.client.jobs.Fetcher;
import com.moonlit.logfaces.client.model.ChoiceModel;
import com.moonlit.logfaces.client.model.ChoiceModelItem;
import com.moonlit.logfaces.client.model.ComponentsModel;
import com.moonlit.logfaces.client.model.EventStyle;
import com.moonlit.logfaces.client.model.LogHeaderInfoVO;
import com.moonlit.logfaces.client.model.QueryVO;
import com.moonlit.logfaces.client.model.TagVO;
import com.moonlit.logfaces.client.model.TagsModel;
import com.moonlit.logfaces.client.model.data.LogDataModel;
import com.moonlit.logfaces.client.model.data.LogModelEvent;
import com.moonlit.logfaces.client.model.data.LogModelListener;
import com.moonlit.logfaces.client.model.filters.LogEventMatcher;
import com.moonlit.logfaces.client.model.filters.LogViewFilter;
import com.moonlit.logfaces.client.model.filters.LogViewFilterImpl;
import com.moonlit.logfaces.client.types.Direction;
import com.moonlit.logfaces.client.types.FileFormat;
import com.moonlit.logfaces.client.types.LfcEvent;
import com.moonlit.logfaces.client.types.TimeRange;
import com.moonlit.logfaces.client.utils.ContextMenuBuilder;
import com.moonlit.logfaces.client.utils.Utils;
import com.moonlit.logfaces.client.widgets.OverviewBar;
import com.moonlit.logfaces.client.widgets.OverviewLevelBar;
import com.moonlit.logfaces.client.widgets.OverviewTagBar;
import com.moonlit.logfaces.server.core.LogEvent;
import com.moonlit.logfaces.server.util.HumanTime;
import com.moonlit.logfaces.server.util.LfsEventBus;
import com.moonlit.logfaces.server.vo.LoggingEventVO;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class QueryResultsEditor
extends EditorPart
implements LogView,
Fontable,
LogModelListener,
IEclipsePreferences.IPreferenceChangeListener,
IPropertyChangeListener {
    public static final String ID = "com.moonlit.logfaces.client.QueryResultsEditor";
    private boolean trim = false;
    private QueryResultsInput input;
    private QueryVO query;
    private LogDataModel model;
    private Composite parent;
    private TableViewer viewer;
    private Table table;
    private Button refreshButton;
    private Button exportButton;
    private Button modifyButton;
    private Button packButton;
    private Button columnsButton;
    private Button resetFilterButton;
    private Button filtersButton;
    private Button autoButton;
    private Button findButton;
    private Button leftButton;
    private Button rightButton;
    private Label infoLabel;
    private OverviewBar overview;
    private OverviewTagBar tagview;
    private LogViewFilter viewFilter = new LogViewFilterImpl();
    private ImageHolder images = ImageHolder.getInstance();
    private Shell shell;
    private Searchable searchAdapter;
    private ComponentsModel components = ComponentsModel.getInstance();
    private TagsModel tagsModel = TagsModel.getInstance();
    private String FONTID = "lfs.font.tables";
    private Font boldFont = Application.getFontRegistry().getBold(this.FONTID);
    private Reloader reloader;
    private LoggingEventVO lastSelected;
    private Map<Integer, Integer> colMap = Maps.newTreeMap();
    private static final Logger log = LogManager.getLogger(QueryResultsEditor.class);
    Date tempDate = new Date();

    @Override
    public LogDataModel getModel() {
        return this.model;
    }

    @Override
    public int getColumnType(int index) {
        for (int abs : this.colMap.keySet()) {
            if (this.colMap.get(abs) != index) continue;
            return abs;
        }
        return -1;
    }

    @Override
    public OverviewBar getLevelOverview() {
        return this.overview;
    }

    @Override
    public OverviewBar getTagsOverview() {
        return this.tagview;
    }

    @Override
    public TableViewer getTableViewer() {
        return this.viewer;
    }

    @Override
    public LogViewFilter getViewFilter() {
        return this.viewFilter;
    }

    @Override
    public void refresh(boolean deep) {
        if (this.table.isDisposed()) {
            return;
        }
        this.table.setRedraw(false);
        this.table.removeAll();
        this.table.setRedraw(true);
        if (deep) {
            this.model.refresh();
        }
        this.populate();
        this.retainSelection();
        Utils.packColumns(this);
    }

    @Override
    public void packColumns() {
        if (this.table.isDisposed()) {
            return;
        }
        this.table.setRedraw(false);
        TableColumn[] tableColumnArray = this.table.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.pack();
            ++n2;
        }
        this.table.setRedraw(true);
        this.table.setFocus();
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public void updateActiveState() {
    }

    private void populate() {
        if (this.table.isDisposed()) {
            return;
        }
        this.viewer.setItemCount(this.model.getSize());
        this.table.clearAll();
        this.updateInfoLabel();
    }

    @Override
    public LoggingEventVO getFilterEvent() {
        TableItem[] selected = this.table.getSelection();
        if (selected == null) {
            return null;
        }
        if (selected.length == 0) {
            return null;
        }
        return (LoggingEventVO)selected[0].getData();
    }

    @Override
    public TimeZone getTimeZone() {
        return this.input != null ? this.input.getTimeZone() : TimeZone.getDefault();
    }

    @Override
    public Searchable getSearchable() {
        return this.searchAdapter;
    }

    @Override
    public QueryVO createPin() throws Exception {
        QueryVO query = this.input.getQuery().clone();
        query.setPinID(UUID.randomUUID().toString());
        ArrayList events = Lists.newArrayList();
        TableItem[] tableItemArray = this.table.getSelection();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            LogEvent event = (LogEvent)item.getData();
            events.add(event);
            query.addPinMark(event.getSequenceNumber());
            ++n2;
        }
        events.sort(new Comparator<LogEvent>(){

            @Override
            public int compare(LogEvent e1, LogEvent e2) {
                if (e1.getLoggerTimeStamp() - e2.getLoggerTimeStamp() > 0L) {
                    return 1;
                }
                if (e1.getLoggerTimeStamp() - e2.getLoggerTimeStamp() < 0L) {
                    return -1;
                }
                return 0;
            }
        });
        if (events.isEmpty()) {
            throw new Exception("nothing to pin");
        }
        int top = this.table.getTopIndex();
        int visible = this.table.getClientArea().height / this.table.getItemHeight();
        LogEvent e1 = (LogEvent)this.table.getItem(top).getData();
        LogEvent e2 = this.model.getStorageData().get(Math.min(top + visible - 1, this.model.getSize() - 1));
        if (query.getOrder().isDecsending()) {
            LogEvent temp = e1;
            e1 = e2;
            e2 = temp;
        }
        query.setTimeRange(TimeRange.CUSTOM_RANGE, Math.min(e1.getLoggerTimeStamp(), ((LogEvent)events.get(0)).getLoggerTimeStamp()), Math.max(e2.getLoggerTimeStamp(), ((LogEvent)events.get(events.size() - 1)).getLoggerTimeStamp()));
        return query;
    }

    public void init(IEditorSite site, IEditorInput inp) throws PartInitException {
        LfsEventBus.getInstance().register((Object)this);
        this.input = (QueryResultsInput)inp;
        this.model = this.input.getFetcher().getResults();
        this.shell = site.getShell();
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(inp);
        this.setPartName(inp.getName());
        log.info("opening query results '{}'", (Object)this.input.getName());
        this.query = this.input.getQuery();
        this.trim = Application.getPrefs().getBoolean("lfs_perspective_trim", false);
        Application.getPrefs().addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        PlatformUI.getWorkbench().getThemeManager().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void setFocus() {
        if (this.table != null && !this.table.isDisposed()) {
            this.table.setFocus();
        }
    }

    public void dispose() {
        log.info("closing query results '{}'", (Object)this.input.getName());
        Application.getPrefs().removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        PlatformUI.getWorkbench().getThemeManager().removePropertyChangeListener((IPropertyChangeListener)this);
        LfsEventBus.getInstance().unregister((Object)this);
        this.input.getFetcher().dispose();
        if (this.reloader != null) {
            this.reloader.interrupt();
        }
        this.model.destroy();
        super.dispose();
        Display.getDefault().asyncExec(() -> this.disconnectFromServer());
    }

    @Override
    public void disconnectFromServer() {
        System.gc();
    }

    private void createButtonBar() {
        Composite bar = new Composite(this.parent, this.parent.getStyle());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = this.input.isFile() ? 6 : 12;
        gridLayout.horizontalSpacing = 0;
        bar.setLayout((Layout)gridLayout);
        if (!this.input.isFile()) {
            this.refreshButton = new Button(bar, 8);
            this.refreshButton.setImage(this.images.getButtonImage("/icons/eclipse3_update.gif"));
            this.refreshButton.setLayoutData((Object)new GridData(16384, 128, false, false));
            this.refreshButton.setToolTipText("Reload the query");
            this.refreshButton.setText("Reload");
            this.refreshButton.setEnabled(this.query != null);
            this.refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    QueryResultsEditor.this.leftButton.setEnabled(false);
                    QueryResultsEditor.this.rightButton.setEnabled(false);
                    QueryResultsEditor.this.refreshButton.setEnabled(false);
                    QueryResultsEditor.this.reload(Direction.none);
                }
            });
            this.modifyButton = new Button(bar, 8);
            this.modifyButton.setImage(this.images.getButtonImage("/icons/preferences.gif"));
            this.modifyButton.setLayoutData((Object)new GridData(16384, 128, false, false));
            this.modifyButton.setToolTipText("Modify query");
            this.modifyButton.setText("Modify");
            this.modifyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    QueryDialog dialog = new QueryDialog(QueryResultsEditor.this.modifyButton.getShell(), QueryResultsEditor.this.query.clone(), true);
                    if (dialog.open() == 0) {
                        QueryResultsEditor.this.query = dialog.getResult();
                        QueryResultsEditor.this.input.setQuery(QueryResultsEditor.this.query);
                        QueryResultsEditor.this.reload(Direction.none);
                    }
                }
            });
        }
        this.columnsButton = new Button(bar, 8);
        this.columnsButton.setImage(this.images.getButtonImage("icons/columns.gif"));
        this.columnsButton.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.columnsButton.setText("Columns");
        this.columnsButton.setToolTipText("Specify columns");
        this.columnsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (new ColumnsDlg(QueryResultsEditor.this.shell, QueryResultsEditor.this.query.getHeaders()).open() == 0) {
                    QueryResultsEditor.this.layoutTable();
                    QueryResultsEditor.this.refresh(false);
                    Utils.packColumns(QueryResultsEditor.this);
                }
            }
        });
        this.packButton = new Button(bar, 8);
        this.packButton.setImage(this.images.getButtonImage("icons/alignwidth.gif"));
        this.packButton.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.packButton.setText("Pack");
        this.packButton.setToolTipText("Pack columns");
        this.packButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QueryResultsEditor.this.packColumns();
            }
        });
        if (!this.input.isFile()) {
            this.exportButton = new Button(bar, 8);
            this.exportButton.setImage(this.images.getButtonImage("/icons/eclipse3_export.gif"));
            this.exportButton.setLayoutData((Object)new GridData(16384, 128, false, false));
            this.exportButton.setText("Send to");
            this.exportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    QueryResultsEditor.this.hookExportMenu();
                }
            });
        }
        this.findButton = new Button(bar, 8);
        this.findButton.setImage(this.images.getButtonImage("icons/feed.gif"));
        this.findButton.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.findButton.setText("Find...");
        this.findButton.setToolTipText("Find matching events (Ctrl+F)");
        this.findButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindDialog.getInstance().activate(QueryResultsEditor.this.searchAdapter);
            }
        });
        this.resetFilterButton = new Button(bar, 8);
        this.resetFilterButton.setImage(this.images.getButtonImage("icons/eclipse3_view.gif"));
        this.resetFilterButton.setText("Clear filters");
        this.resetFilterButton.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.resetFilterButton.setToolTipText("Clear view filters");
        this.resetFilterButton.setVisible(false);
        this.resetFilterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QueryResultsEditor.this.resetFilter();
                QueryResultsEditor.this.applyFilter(-1);
                QueryResultsEditor.this.resetFilterButton.setVisible(false);
                QueryResultsEditor.this.filtersButton.setVisible(false);
            }
        });
        this.filtersButton = new Button(bar, 8);
        this.filtersButton.setImage(this.images.getButtonImage("icons/dots.png"));
        this.filtersButton.setText("");
        this.filtersButton.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.filtersButton.setToolTipText("Manage applied filters");
        this.filtersButton.setVisible(false);
        this.filtersButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QueryResultsEditor.this.adjustFilter();
            }
        });
        if (!this.input.isFile()) {
            this.leftButton = new Button(bar, 8);
            this.leftButton.setImage(this.images.getButtonImage("/icons/e_back.gif"));
            this.leftButton.setText(Util.isMac() ? "<" : "");
            GridData gd = new GridData(16384, 0x1000000, false, false);
            gd.horizontalIndent = 20;
            this.leftButton.setLayoutData((Object)gd);
            this.leftButton.setToolTipText("Page backward");
            this.leftButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    QueryResultsEditor.this.leftButton.setEnabled(false);
                    QueryResultsEditor.this.rightButton.setEnabled(false);
                    QueryResultsEditor.this.refreshButton.setEnabled(false);
                    QueryResultsEditor.this.reload(Direction.backward);
                }
            });
        }
        this.infoLabel = new Label(bar, 0);
        this.infoLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        if (!this.input.isFile()) {
            this.rightButton = new Button(bar, 8);
            this.rightButton.setImage(this.images.getButtonImage("/icons/e_forward.gif"));
            this.rightButton.setText(Util.isMac() ? ">" : "");
            this.rightButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            this.rightButton.setToolTipText("Page forward");
            this.rightButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    QueryResultsEditor.this.leftButton.setEnabled(false);
                    QueryResultsEditor.this.rightButton.setEnabled(false);
                    QueryResultsEditor.this.refreshButton.setEnabled(false);
                    QueryResultsEditor.this.reload(Direction.forward);
                }
            });
        }
        if (!this.input.isFile()) {
            this.autoButton = new Button(bar, 32);
            this.resetFilterButton.setImage(this.images.getButtonImage("icons/eclipse3_view.gif"));
            this.autoButton.setText("auto-reload");
            this.autoButton.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
            this.autoButton.setToolTipText("Do periodic re-loading");
            this.autoButton.setVisible(true);
            this.autoButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (!QueryResultsEditor.this.autoButton.getSelection()) {
                        if (QueryResultsEditor.this.reloader != null) {
                            QueryResultsEditor.this.reloader.interrupt();
                        }
                        QueryResultsEditor.this.reloader = null;
                        QueryResultsEditor.this.table.setFocus();
                        return;
                    }
                    InputDialog dialog = new InputDialog(QueryResultsEditor.this.getSite().getShell(), "Auto-reload preriod", "How often to re-load this query (in minutes):", "5", null);
                    if (dialog.open() != 0) {
                        QueryResultsEditor.this.autoButton.setSelection(false);
                        QueryResultsEditor.this.table.setFocus();
                        return;
                    }
                    try {
                        int minutes = Integer.parseInt(dialog.getValue());
                        if (minutes <= 0) {
                            throw new Exception("");
                        }
                        QueryResultsEditor.this.reloader = new Reloader(minutes);
                        QueryResultsEditor.this.reloader.start();
                        QueryResultsEditor.this.table.setFocus();
                    }
                    catch (Exception ex) {
                        QueryResultsEditor.this.autoButton.setSelection(false);
                        MessageDialog.openError((Shell)QueryResultsEditor.this.getSite().getShell(), (String)"Input", (String)"Please specify whole positive non-zero value in minutes");
                        return;
                    }
                }
            });
        }
        bar.setLayoutData((Object)new GridData(4, 1, true, false, 3, 1));
    }

    private void hookExportMenu() {
        MenuManager menuMgr = new MenuManager("exportPopup");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)new ExportToLogFileAction(QueryResultsEditor.this, QueryResultsEditor.this.input.getName(), FileFormat.pattern));
                manager.add((IAction)new ExportToLogFileAction(QueryResultsEditor.this, QueryResultsEditor.this.input.getName(), FileFormat.csv));
                manager.add((IAction)new ExportToLogFileAction(QueryResultsEditor.this, QueryResultsEditor.this.input.getName(), FileFormat.pattern, false, true));
                manager.add((IContributionItem)new Separator("additions"));
                manager.add((IAction)new ExportQueryAction(QueryResultsEditor.this.query));
            }
        });
        Point point = this.exportButton.getParent().toDisplay(this.exportButton.getLocation());
        point.y += this.exportButton.getSize().y;
        point.y += 2;
        Menu menu = menuMgr.createContextMenu((Control)this.exportButton);
        menu.setLocation(point);
        menu.setVisible(true);
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        parent.setLayout((Layout)gridLayout);
        this.createButtonBar();
        this.tagview = new OverviewTagBar(parent, this);
        GridData gd1 = new GridData();
        gd1.widthHint = 10;
        gd1.grabExcessVerticalSpace = true;
        gd1.verticalAlignment = 4;
        this.tagview.getControl().setLayoutData((Object)gd1);
        LogHeaderInfoVO[] headers = this.query.getHeaders();
        if (headers.length != Columns.getNofColumns()) {
            headers = Columns.makeDefaultHeaders();
            this.query.setHeaders(headers);
        }
        this.viewer = new TableViewer(parent, 268503810);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.table = this.viewer.getTable();
        this.viewer.setItemCount(this.model.getSize());
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.table.setData((Object)this.model);
        this.table.setFont(Application.getFontRegistry().get(this.FONTID));
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        Utils.optimizeRowHeight(this.table);
        this.layoutTable();
        this.overview = new OverviewLevelBar(parent, this);
        GridData gd = new GridData();
        gd.widthHint = 12;
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 4;
        this.overview.getControl().setLayoutData((Object)gd);
        if (!Application.getPrefs().getBoolean("tip_first_time_query", false)) {
            Application.getPrefs().putBoolean("tip_first_time_query", true);
            Utils.displayPopup("One time tip", "You can apply view filters to this data set by clicking on certain column headers. This will refine the view even further. \n\nUse mouse right click within the table to obtain more options.\n\n(this message will not appear again)", false);
        }
        this.table.addMouseListener((MouseListener)new TableMouseAdapter());
        this.table.addListener(36, (Listener)new MyTableListener());
        this.table.addListener(40, (Listener)new TableDrawListener());
        this.model.addListener(this);
        this.tagview.setView(this);
        this.overview.setView(this);
        this.populate();
        Utils.packColumns(this);
        this.hookContextMenu();
        this.searchAdapter = new SearchAdapter(this);
        this.getSite().getWorkbenchWindow().getActivePage().activate((IWorkbenchPart)this);
        this.setTitleImage(this.input.getImage());
    }

    private void layoutTable() {
        this.table.setRedraw(false);
        TableColumn[] tableColumnArray = this.table.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.dispose();
            ++n2;
        }
        LogHeaderInfoVO[] headers = this.query.getHeaders();
        Image timeIcon = this.images.getImage(this.model.isDescending() ? "/icons/select_prev.gif" : "/icons/select_next.gif");
        TableLayout layout = new TableLayout();
        this.colMap.clear();
        int colNumber = 0;
        int i = 0;
        while (i < headers.length) {
            if (headers[i].isVisible()) {
                layout.addColumnData((ColumnLayoutData)new ColumnPixelData(headers[i].getWidth(), true));
                TableColumn col = new TableColumn(this.table, 16384);
                col.setText(headers[i].getName());
                col.setResizable(true);
                col.setWidth(headers[i].getWidth());
                col.setData((Object)i);
                if (i != 9 && i != 11) {
                    col.setToolTipText("click to set view filter");
                    col.addListener(13, (Listener)new HeaderColumnListener());
                }
                if (i == 2 || i == 3) {
                    col.setImage(timeIcon);
                    col.setToolTipText("click to change order");
                }
                if (Columns.isMdcColumn(i)) {
                    col.setText(Columns.column2mdc(i));
                }
                this.colMap.put(i, colNumber++);
            }
            ++i;
        }
        if (this.colMap.containsKey(12)) {
            int mc = this.colMap.get(12);
            List<Integer> order = Utils.toList(this.table.getColumnOrder());
            order.remove((Object)mc);
            order.add(mc);
            this.table.setColumnOrder(Utils.toArray(order));
        }
        this.tagview.setShowTags(this.colMap.containsKey(1));
        this.tagview.modelUpdated(LogModelEvent.RETAG);
        this.table.setLayout((Layout)layout);
        this.table.setRedraw(true);
    }

    private TableColumn getColumn(int index) {
        try {
            TableColumn column = this.table.getColumn(this.colMap.get(index).intValue());
            return column;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("drillDownPopup");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                new ContextMenuBuilder(QueryResultsEditor.this).build(manager);
                Utils.setContextVariable("headers", QueryResultsEditor.this.query.getHeaders());
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void reload(final Direction direction) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                QueryResultsEditor.this.input.page(direction);
                Fetcher fetcher = QueryResultsEditor.this.input.getFetcher();
                fetcher.dispose();
                System.gc();
                FetchQueryRapidJob job = new FetchQueryRapidJob(fetcher);
                job.setUser(true);
                job.schedule(0L);
                QueryResultsEditor.this.table.setFocus();
            }
        });
    }

    public void reload(QueryResultsInput inp) {
        this.input = inp;
        this.query = this.input.getQuery();
        this.model = this.input.getFetcher().getResults();
        this.model.addListener(this);
        this.table.setData((Object)this.model);
        this.overview.setView(this);
        this.tagview.setView(this);
        this.resetFilter();
        this.populate();
    }

    private void resetFilter() {
        this.viewFilter.reset();
        this.resetFilterButton.setVisible(false);
        TableColumn[] tableColumnArray = this.table.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            int index = (Integer)column.getData();
            if (index != 2 && index != 3) {
                column.setImage(null);
            }
            ++n2;
        }
    }

    @Override
    public void applyFilter(int columnIndex) {
        this.model.setViewFilter(this.viewFilter);
        this.resetFilterButton.setVisible(true);
        this.filtersButton.setVisible(this.viewFilter.getMatchers().size() > 1);
        try {
            TableColumn column = this.getColumn(columnIndex);
            if (column != null) {
                column.setImage(this.images.getImage("icons/eclipse3_view.gif"));
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private void adjustFilter() {
        ChoiceModel choice = new ChoiceModel();
        for (LogEventMatcher matcher : this.viewFilter.getMatchers()) {
            choice.addItem(matcher, matcher.isEnabled());
        }
        ListSelectionDialog dialog = new ListSelectionDialog("Check filters to enable", "icons/eclipse3_view.gif", choice);
        dialog.setFilter(false);
        if (dialog.open() != 0) {
            return;
        }
        ChoiceModelItem[] choiceModelItemArray = choice.getItems();
        int n = choiceModelItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ChoiceModelItem item = choiceModelItemArray[n2];
            LogEventMatcher matcher = (LogEventMatcher)item.getItem();
            matcher.setEnabled(item.isSelected());
            ++n2;
        }
        this.applyFilter(-1);
    }

    @Override
    public void modelUpdated(LogModelEvent event) {
        if (this.table.isDisposed()) {
            return;
        }
        this.viewer.setItemCount(this.model.getSize());
        this.table.clearAll();
        this.updateInfoLabel();
        if (LogModelEvent.FINALIZED.equals((Object)event)) {
            this.leftButton.setEnabled(true);
            this.rightButton.setEnabled(true);
            this.refreshButton.setEnabled(true);
            Utils.packColumns(this);
            int index = this.model.getDrillEventIndex();
            if (index >= 0) {
                this.model.addBookmark(index);
            } else {
                index = this.model.getIndexOfFirstBookmark();
            }
            if (index >= 0) {
                TableItem item = this.table.getItem(index);
                this.table.showItem(item);
                this.table.setFocus();
                this.table.setTopIndex(index >= 10 ? index - 10 : 0);
            }
        }
        if (LogModelEvent.FILTERED.equals((Object)event)) {
            Utils.packColumns(this);
        }
    }

    @Subscribe
    public void handleLfcEvent(final LfcEvent event) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (QueryResultsEditor.this.refreshButton == null || QueryResultsEditor.this.refreshButton.isDisposed()) {
                    return;
                }
                if (event.is(LfcEvent.TYPE.CONNECTED)) {
                    QueryResultsEditor.this.refreshButton.setEnabled(true);
                    QueryResultsEditor.this.modifyButton.setEnabled(true);
                    QueryResultsEditor.this.autoButton.setEnabled(true);
                } else if (event.is(LfcEvent.TYPE.DISCONNECTED)) {
                    QueryResultsEditor.this.refreshButton.setEnabled(false);
                    QueryResultsEditor.this.modifyButton.setEnabled(false);
                    QueryResultsEditor.this.autoButton.setEnabled(false);
                } else if (event.is(LfcEvent.TYPE.GIS_SELECT)) {
                    GisLocation location = (GisLocation)((Object)event.getContext());
                    int index = QueryResultsEditor.this.model.find(location.getIp(), 0, true);
                    QueryResultsEditor.this.reveal(index);
                }
            }
        });
    }

    private void updateInfoLabel() {
        DateTimeZone dtz = DateTimeZone.forTimeZone((TimeZone)this.input.getTimeZone());
        DateTimeFormatter dtf = DateTimeFormat.forPattern((String)"dd MMM HH:mm");
        this.infoLabel.setText(String.format(" %s - %s, fecthed %d events (%s) ", dtf.withZone(dtz).print(this.input.getQuery().getFromTime()), dtf.withZone(dtz).print(this.input.getQuery().getToTime()), this.model.getSize(), HumanTime.exactly((long)this.input.getFetcher().getQueryTime())));
        this.infoLabel.requestLayout();
    }

    public void retainSelection() {
        int index = this.model.getIndexOf((LogEvent)this.lastSelected);
        if (index == -1) {
            return;
        }
        TableItem item = this.table.getItem(index);
        this.table.setSelection(index);
        this.table.showItem(item);
        this.table.setFocus();
        this.table.setTopIndex(index - 10);
        this.viewer.setSelection(this.viewer.getSelection());
    }

    public void reveal(int index) {
        if (index == -1) {
            return;
        }
        int topIndex = index - 5;
        this.table.setTopIndex(topIndex > 0 ? topIndex : 0);
        this.table.setSelection(index);
        this.viewer.setSelection(this.viewer.getSelection());
    }

    @Override
    public void handleOverviewSelection(int index, int y) {
        try {
            int itemHeight = this.table.getItemHeight();
            int topIndex = y / itemHeight;
            this.table.setTopIndex(index - topIndex + 1);
            this.table.setSelection(index);
            this.table.setFocus();
            this.viewer.setSelection(this.viewer.getSelection());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        String key = event.getKey();
        if ("lfs_levels".equals(key)) {
            this.refresh(true);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.FONTID.equals(event.getProperty())) {
            this.table.setFont(Application.getFontRegistry().get(this.FONTID));
            this.refresh(true);
            Utils.optimizeRowHeight(this.table);
        }
    }

    @Override
    public String getFontID() {
        return this.FONTID;
    }

    class HeaderColumnListener
    implements Listener {
        HeaderColumnListener() {
        }

        public void handleEvent(Event event) {
            TableColumn column = (TableColumn)event.widget;
            int index = (Integer)column.getData();
            String filter = null;
            switch (index) {
                case 2: 
                case 3: {
                    QueryResultsEditor.this.model.revert();
                    Image image = QueryResultsEditor.this.images.getImage(QueryResultsEditor.this.model.isDescending() ? "/icons/select_prev.gif" : "/icons/select_next.gif");
                    TableColumn tc = QueryResultsEditor.this.getColumn(2);
                    if (tc != null) {
                        tc.setImage(image);
                    }
                    if ((tc = QueryResultsEditor.this.getColumn(3)) != null) {
                        tc.setImage(image);
                    }
                    return;
                }
                case 7: {
                    WildCardExpressionDialog dlg = new WildCardExpressionDialog(QueryResultsEditor.this.getSite().getShell(), "Loggers expression", "", QueryResultsEditor.this.model.getOptions(index));
                    if (dlg.open() == 1) {
                        return;
                    }
                    filter = dlg.getExpression();
                    if (!filter.equals("*")) break;
                    filter = null;
                    break;
                }
                case 10: {
                    ColumnFilterDlg dlg = new ColumnFilterDlg(QueryResultsEditor.this.getSite(), Lists.newArrayList((Object[])new String[]{"only thrown"}), false);
                    if (dlg.open() == 1) {
                        return;
                    }
                    filter = dlg.getOption();
                    break;
                }
                case 0: 
                case 12: {
                    ColumnFilterDlg dlg = new ColumnFilterDlg(QueryResultsEditor.this.getSite(), QueryResultsEditor.this.model.getOptions(index), index == 12);
                    if (dlg.open() == 1) {
                        return;
                    }
                    filter = dlg.getOption();
                    break;
                }
                default: {
                    ChoiceModel choice = new ChoiceModel(QueryResultsEditor.this.model.getOptions(index));
                    ListSelectionDialog dialog = new ListSelectionDialog("Check items to display", "icons/eclipse3_view.gif", choice);
                    if (dialog.open() != 0) {
                        return;
                    }
                    filter = choice.getSelectionAsRegex();
                }
            }
            QueryResultsEditor.this.viewFilter.setFocus(index, filter);
            QueryResultsEditor.this.applyFilter(index);
            QueryResultsEditor.this.resetFilterButton.setVisible(filter != null);
            if (filter == null) {
                column.setImage(null);
            }
        }
    }

    class MyTableListener
    implements Listener {
        MyTableListener() {
        }

        public void handleEvent(Event e) {
            TableItem item = (TableItem)e.item;
            int index = QueryResultsEditor.this.table.indexOf(item);
            LoggingEventVO event = (LoggingEventVO)QueryResultsEditor.this.model.getViewItem(index);
            if (event != null) {
                EventStyle style = QueryResultsEditor.this.model.getStyle((LogEvent)event);
                if (QueryResultsEditor.this.colMap.containsKey(0)) {
                    item.setImage(QueryResultsEditor.this.colMap.get(0).intValue(), style.getImage());
                }
                item.setBackground(style.getBackground());
                item.setForeground(style.getForeground());
                if (style.isBold()) {
                    item.setFont(QueryResultsEditor.this.boldFont);
                }
                item.setData((Object)event);
                QueryResultsEditor.this.tempDate.setTime(event.getLoggerTimeStamp());
                if (QueryResultsEditor.this.colMap.containsKey(3)) {
                    item.setText(QueryResultsEditor.this.colMap.get(3).intValue(), QueryResultsEditor.this.query.getTimeFormat().format(QueryResultsEditor.this.tempDate));
                }
                if (QueryResultsEditor.this.colMap.containsKey(2)) {
                    item.setText(QueryResultsEditor.this.colMap.get(2).intValue(), QueryResultsEditor.this.query.getDateFormat().format(QueryResultsEditor.this.tempDate));
                }
                if (QueryResultsEditor.this.colMap.containsKey(5)) {
                    item.setText(QueryResultsEditor.this.colMap.get(5).intValue(), event.getDomainName());
                }
                if (QueryResultsEditor.this.colMap.containsKey(6)) {
                    item.setText(QueryResultsEditor.this.colMap.get(6).intValue(), QueryResultsEditor.this.components.getComponent(event));
                }
                if (QueryResultsEditor.this.colMap.containsKey(4)) {
                    item.setText(QueryResultsEditor.this.colMap.get(4).intValue(), event.getHostName());
                }
                if (QueryResultsEditor.this.colMap.containsKey(7)) {
                    item.setText(QueryResultsEditor.this.colMap.get(7).intValue(), event.getLoggerNameShort());
                }
                if (QueryResultsEditor.this.colMap.containsKey(8)) {
                    item.setText(QueryResultsEditor.this.colMap.get(8).intValue(), event.getThreadName());
                }
                if (QueryResultsEditor.this.colMap.containsKey(9)) {
                    item.setText(QueryResultsEditor.this.colMap.get(9).intValue(), Utils.getLocationInfo((LogEvent)event));
                }
                if (QueryResultsEditor.this.colMap.containsKey(10) && event.isThrown()) {
                    item.setText(QueryResultsEditor.this.colMap.get(10).intValue(), "( ! )");
                }
                if (QueryResultsEditor.this.colMap.containsKey(11)) {
                    item.setText(QueryResultsEditor.this.colMap.get(11).intValue(), event.getNdc());
                }
                if (QueryResultsEditor.this.colMap.containsKey(12)) {
                    String message = StringUtils.abbreviate((String)event.getMessage(), (int)259);
                    message = QueryResultsEditor.this.trim ? StringUtils.replaceChars((String)message, (String)"\r\n", (String)"") : message;
                    item.setText(QueryResultsEditor.this.colMap.get(12).intValue(), message);
                }
                for (String property : event.getProperties().keySet()) {
                    int col;
                    String value = event.getProperty(property);
                    if (value == null || !QueryResultsEditor.this.colMap.containsKey(col = Columns.mdc2column(property))) continue;
                    item.setText(QueryResultsEditor.this.colMap.get(col).intValue(), value);
                }
                TagVO tag = QueryResultsEditor.this.tagsModel.findOne((LogEvent)event);
                if (QueryResultsEditor.this.colMap.containsKey(1) && tag != null) {
                    item.setText(QueryResultsEditor.this.colMap.get(1).intValue(), (String)event.getProperties().get("tags"));
                    item.setBackground(QueryResultsEditor.this.colMap.get(1).intValue(), tag.getColor());
                    item.setForeground(QueryResultsEditor.this.colMap.get(1).intValue(), Utils.pickForeground(tag.getColor()));
                }
            }
        }
    }

    class Reloader
    extends Thread {
        private long sleep;

        public Reloader(int minutes) {
            this.sleep = minutes * 60 * 1000;
        }

        @Override
        public void run() {
            while (!this.isInterrupted()) {
                try {
                    Thread.sleep(this.sleep);
                    QueryResultsEditor.this.reload(Direction.none);
                }
                catch (Exception e) {
                    break;
                }
            }
        }
    }

    class TableDrawListener
    implements Listener {
        TableDrawListener() {
        }

        public void handleEvent(Event event) {
            if (Util.isMac()) {
                Utils.overrideTableSelectionPaint(event, QueryResultsEditor.this.table);
                return;
            }
            if (!QueryResultsEditor.this.colMap.containsKey(1)) {
                return;
            }
            if (event.index != QueryResultsEditor.this.colMap.get(1)) {
                return;
            }
            TableColumn tc = QueryResultsEditor.this.getColumn(1);
            if (tc == null) {
                return;
            }
            TableItem item = (TableItem)event.item;
            if (item == null || item.isDisposed()) {
                return;
            }
            if (item.getText(event.index).isEmpty()) {
                return;
            }
            Rectangle rect = item.getBounds(event.index);
            event.gc.fillRectangle(rect);
        }
    }

    class TableMouseAdapter
    extends MouseAdapter {
        TableMouseAdapter() {
        }

        public void mouseDown(MouseEvent e) {
            if (QueryResultsEditor.this.table.getItemCount() == 0) {
                return;
            }
            TableItem[] selected = QueryResultsEditor.this.table.getSelection();
            if (selected == null || selected.length == 0) {
                return;
            }
            QueryResultsEditor.this.lastSelected = (LoggingEventVO)selected[0].getData();
            QueryResultsEditor.this.model.setSelectedEvent((LogEvent)QueryResultsEditor.this.lastSelected);
        }

        public void mouseDoubleClick(MouseEvent e) {
            if (QueryResultsEditor.this.table.getItemCount() == 0) {
                return;
            }
            TableItem[] selected = QueryResultsEditor.this.table.getSelection();
            if (selected == null) {
                return;
            }
            if (selected.length != 1) {
                return;
            }
            QueryResultsEditor.this.lastSelected = (LoggingEventVO)selected[0].getData();
            if (QueryResultsEditor.this.lastSelected == null) {
                return;
            }
            QueryResultsEditor.this.model.setSelectedEvent((LogEvent)QueryResultsEditor.this.lastSelected);
            new BrowseDetailsAction(QueryResultsEditor.this.lastSelected).run();
            QueryResultsEditor.this.getSite().getWorkbenchWindow().getActivePage().activate((IWorkbenchPart)QueryResultsEditor.this);
        }
    }
}

