/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.editors;

import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.ImageHolder;
import com.moonlit.logfaces.client.dialogs.PatternsTestDialog;
import com.moonlit.logfaces.client.editors.Searchable;
import com.moonlit.logfaces.client.model.SearchOptions;
import com.moonlit.logfaces.client.net.LfsConnector;
import com.moonlit.logfaces.client.text.PatternsLineStyler;
import com.moonlit.logfaces.client.utils.StringUtils;
import com.moonlit.logfaces.server.util.Patterns;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;

public class PatternsEditor
extends EditorPart
implements IPropertyChangeListener,
Searchable {
    public static final String ID = "com.moonlit.logfaces.client.editors.PatternsEditor";
    private Composite parent;
    private Button saveButton;
    private StyledText text;
    private String FONT = "lfs.font.sources";
    private PatternsLineStyler lineStyler;
    private ImageHolder images = ImageHolder.getInstance();
    private boolean dirty;
    private boolean searchActive;
    private File file = new File(Patterns.getInstance().getFileName());
    private static Logger log = LogManager.getLogger(PatternsEditor.class);

    public void doSave(IProgressMonitor monitor) {
        this.save();
    }

    public void doSaveAs() {
        this.save();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void setFocus() {
    }

    public void dispose() {
        if (this.lineStyler != null) {
            this.lineStyler.dispose();
        }
        PlatformUI.getWorkbench().getThemeManager().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public void init(IEditorSite site, IEditorInput inp) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(inp);
        this.setPartName(inp.getName());
        this.lineStyler = new PatternsLineStyler();
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.createButtonBar();
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        parent.setLayout((Layout)gridLayout);
        this.text = new StyledText(parent, 2818);
        GridData spec = new GridData();
        spec.horizontalAlignment = 4;
        spec.grabExcessHorizontalSpace = true;
        spec.verticalAlignment = 4;
        spec.grabExcessVerticalSpace = true;
        this.text.setLayoutData((Object)spec);
        this.text.addLineStyleListener((LineStyleListener)this.lineStyler);
        this.text.setEditable(true);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PatternsEditor.this.setDirty(true);
            }
        });
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if ((e.stateMask & 0x40000) == 262144 && e.keyCode == 115) {
                    PatternsEditor.this.save();
                }
            }
        });
        this.text.setFont(Application.getFontRegistry().get(this.FONT));
        this.text.setBackground(Display.getDefault().getSystemColor(1));
        this.showText();
        this.setDirty(false);
        PlatformUI.getWorkbench().getThemeManager().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    private void createButtonBar() {
        Button button;
        Composite bar = new Composite(this.parent, this.parent.getStyle());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = Application.isServerMode() ? 2 : 4;
        gridLayout.horizontalSpacing = 0;
        bar.setLayout((Layout)gridLayout);
        GridData buttonGd = new GridData(4, 4, true, true);
        buttonGd.heightHint = 26;
        buttonGd.widthHint = 120;
        buttonGd.verticalAlignment = 16;
        this.saveButton = new Button(bar, 8);
        this.saveButton.setLayoutData((Object)buttonGd);
        this.saveButton.setImage(this.images.getButtonImage("/icons/saveas_edit.gif"));
        this.saveButton.setText("Save");
        this.saveButton.setEnabled(this.dirty);
        this.saveButton.setToolTipText("Save pattern library locally");
        this.saveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PatternsEditor.this.save();
            }
        });
        if (!Application.isServerMode()) {
            button = new Button(bar, 8);
            button.setLayoutData((Object)buttonGd);
            button.setImage(this.images.getButtonImage("/icons/eclipse3_import.gif"));
            button.setText("Import");
            button.setToolTipText("Import library from server and keep as a local copy");
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PatternsEditor.this.download();
                }
            });
            button = new Button(bar, 8);
            button.setLayoutData((Object)buttonGd);
            button.setImage(this.images.getButtonImage("/icons/eclipse3_export.gif"));
            button.setText("Export");
            button.setToolTipText("Export these patterns to server for sharing");
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PatternsEditor.this.upload();
                }
            });
        }
        button = new Button(bar, 8);
        button.setLayoutData((Object)buttonGd);
        button.setImage(this.images.getButtonImage("icons/level_debug3.gif"));
        button.setText("Test");
        button.setToolTipText("Run regular expression tests");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PatternsTestDialog dlg = new PatternsTestDialog(PatternsEditor.this.getSite().getShell());
                dlg.open();
            }
        });
    }

    private void showText() {
        String textString;
        if (!this.file.exists()) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Failed", (String)String.format("File not found: %s", this.file.getName()));
            return;
        }
        try {
            FileInputStream stream = new FileInputStream(this.file.getPath());
            try {
                int n;
                BufferedReader in = new BufferedReader(new InputStreamReader(stream));
                char[] readBuffer = new char[2048];
                StringBuffer buffer = new StringBuffer((int)this.file.length());
                while ((n = in.read(readBuffer)) > 0) {
                    buffer.append(readBuffer, 0, n);
                }
                textString = buffer.toString();
                stream.close();
            }
            catch (IOException e) {
                MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Failed", (String)String.format("%s\n%s", e.getMessage(), this.file.getName()));
                return;
            }
        }
        catch (FileNotFoundException e) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Failed", (String)String.format("%s\n%s", e.getMessage(), this.file.getName()));
            return;
        }
        this.text.setData("currentLine", (Object)0);
        this.text.setText(textString);
        this.text.setTopIndex(Math.max(0, 0));
        this.text.setFocus();
    }

    private void setDirty(boolean dirty) {
        this.dirty = dirty;
        this.saveButton.setEnabled(dirty);
        this.firePropertyChange(257);
    }

    private void save() {
        try {
            FileWriter writer = new FileWriter(this.file);
            IOUtils.write((String)this.text.getText(), (Writer)writer);
            ((Writer)writer).flush();
            ((Writer)writer).close();
            this.setDirty(false);
            Patterns.getInstance().restart();
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Failed", (String)e.getMessage());
        }
    }

    private void download() {
        if (!MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)"Please confirm", (String)"This will import patterns library from server and store it locally. Your local copy will be replaced.")) {
            return;
        }
        try {
            LfsConnector connector = LfsConnector.getInstance();
            InputStream is = connector.getConnection().getPatternLibrary(connector.getSid());
            FileUtils.copyInputStreamToFile((InputStream)is, (File)this.file);
            this.showText();
            this.setDirty(false);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Failed", (String)e.getMessage());
        }
    }

    private void upload() {
        if (!MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)"Please confirm", (String)"This will upload local patterns library into server for sharing. Note that this will directly affect server parsing activities and all other users depending on regular expressions patterns.")) {
            return;
        }
        try {
            this.save();
            LfsConnector connector = LfsConnector.getInstance();
            connector.getConnection().savePatternLibrary(connector.getSid(), (InputStream)new FileInputStream(this.file));
            this.setDirty(false);
            MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)"Done", (String)"Pattern library is successfully uploaded to server");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Failed", (String)e.getMessage());
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.FONT.equals(event.getProperty())) {
            this.text.setFont(Application.getFontRegistry().get("lfs.font.sources"));
        }
    }

    @Override
    public boolean findNext(SearchOptions options) {
        int start;
        String what = options.getSearchText();
        if (!StringUtils.hasText(what)) {
            return false;
        }
        String content = this.text.getText();
        int from = content.indexOf(what, start = this.text.getCaretOffset());
        if (from < 0) {
            return false;
        }
        int line = this.text.getLineAtOffset(from);
        this.text.setSelection(from, from + what.length());
        this.text.setTopIndex(Math.max(0, line - 5));
        return true;
    }

    @Override
    public boolean findPrev(SearchOptions options) {
        int start;
        String what = options.getSearchText();
        if (!StringUtils.hasText(what)) {
            return false;
        }
        String content = this.text.getText();
        int from = content.lastIndexOf(what, start = this.text.getCaretOffset() - this.text.getSelectionCount() - 1);
        if (from < 0) {
            return false;
        }
        int line = this.text.getLineAtOffset(from);
        this.text.setSelection(from, from + what.length());
        this.text.setTopIndex(Math.max(0, line - 5));
        return true;
    }

    @Override
    public boolean findAndMark(SearchOptions options) {
        return false;
    }

    @Override
    public void unmark() {
    }

    @Override
    public boolean findAndFilter(SearchOptions options) {
        return false;
    }

    @Override
    public void unfilter() {
    }

    @Override
    public boolean canFindAnnotate() {
        return false;
    }

    @Override
    public boolean isMarked() {
        return false;
    }

    @Override
    public boolean isFiltered() {
        return false;
    }

    @Override
    public boolean isActive() {
        return this.searchActive;
    }

    @Override
    public void setActive(boolean active) {
        this.searchActive = active;
    }
}

