/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.editors;

import com.moonlit.logfaces.client.model.PerspectiveVO;
import com.moonlit.logfaces.client.utils.StringUtils;
import com.moonlit.logfaces.server.criteria.CriteriaFilter;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public class LogEditorInput
implements IEditorInput {
    PerspectiveVO vo;
    CriteriaFilter rtCriteria;
    boolean isEmbedded;
    Map<String, String> params;

    public LogEditorInput(PerspectiveVO vo) {
        this.setValueObject(vo);
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        if (this.params == null || this.params.isEmpty()) {
            return this.vo.getName();
        }
        String values = StringUtils.collectionToCommaDelimitedString(this.params.values());
        return String.format("%s (%s)", this.vo.getName(), values);
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (!(obj instanceof LogEditorInput)) {
            return false;
        }
        LogEditorInput other = (LogEditorInput)obj;
        return this.vo.getName().equals(other.vo.getName());
    }

    public int hashCode() {
        return this.vo.getName().hashCode();
    }

    public String getToolTipText() {
        return this.vo.getName();
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public boolean isEmbedded() {
        return this.isEmbedded;
    }

    public void setEmbedded(boolean isEmbedded) {
        this.isEmbedded = isEmbedded;
    }

    public CriteriaFilter getRtCriteria() {
        return this.rtCriteria;
    }

    public void setRtCriteria(CriteriaFilter rtCriteria) {
        this.rtCriteria = rtCriteria;
    }

    public void setValueObject(PerspectiveVO vo) {
        this.vo = vo;
        this.rtCriteria = vo.getCriteria().clone();
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public void setReopen(boolean reopen) {
        this.vo.setOpened(reopen);
    }

    public boolean isReopen() {
        return this.vo.isOpened();
    }
}

