/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.editors;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.eventbus.Subscribe;
import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.Columns;
import com.moonlit.logfaces.client.Fontable;
import com.moonlit.logfaces.client.ImageHolder;
import com.moonlit.logfaces.client.actions.BrowseDetailsAction;
import com.moonlit.logfaces.client.actions.ExportToLogFileAction;
import com.moonlit.logfaces.client.dialogs.ColumnFilterDlg;
import com.moonlit.logfaces.client.dialogs.ColumnsDlg;
import com.moonlit.logfaces.client.dialogs.FindDialog;
import com.moonlit.logfaces.client.dialogs.ListSelectionDialog;
import com.moonlit.logfaces.client.dialogs.LogPerspectiveDlg;
import com.moonlit.logfaces.client.dialogs.WildCardExpressionDialog;
import com.moonlit.logfaces.client.editors.LogEditorInput;
import com.moonlit.logfaces.client.editors.LogView;
import com.moonlit.logfaces.client.editors.SearchAdapter;
import com.moonlit.logfaces.client.editors.Searchable;
import com.moonlit.logfaces.client.embedded.LfsEmbeddedSession;
import com.moonlit.logfaces.client.gis.GisLocation;
import com.moonlit.logfaces.client.jobs.PerspectiveActivatorJob;
import com.moonlit.logfaces.client.model.ChoiceModel;
import com.moonlit.logfaces.client.model.ChoiceModelItem;
import com.moonlit.logfaces.client.model.ComponentsModel;
import com.moonlit.logfaces.client.model.EventStyle;
import com.moonlit.logfaces.client.model.LogHeaderInfoVO;
import com.moonlit.logfaces.client.model.LogPerspectivesModel;
import com.moonlit.logfaces.client.model.QueryVO;
import com.moonlit.logfaces.client.model.TagVO;
import com.moonlit.logfaces.client.model.TagsModel;
import com.moonlit.logfaces.client.model.data.Annotation;
import com.moonlit.logfaces.client.model.data.Log4jModel;
import com.moonlit.logfaces.client.model.data.LogDataModel;
import com.moonlit.logfaces.client.model.data.LogEventListener;
import com.moonlit.logfaces.client.model.data.LogModelEvent;
import com.moonlit.logfaces.client.model.data.LogModelListener;
import com.moonlit.logfaces.client.model.filters.LogEventMatcher;
import com.moonlit.logfaces.client.model.filters.LogViewFilter;
import com.moonlit.logfaces.client.model.filters.LogViewFilterImpl;
import com.moonlit.logfaces.client.net.LfsConnector;
import com.moonlit.logfaces.client.net.NotConnectedException;
import com.moonlit.logfaces.client.types.FileFormat;
import com.moonlit.logfaces.client.types.LfcEvent;
import com.moonlit.logfaces.client.types.TimeRange;
import com.moonlit.logfaces.client.utils.ContextMenuBuilder;
import com.moonlit.logfaces.client.utils.Utils;
import com.moonlit.logfaces.client.widgets.OverviewBar;
import com.moonlit.logfaces.client.widgets.OverviewLevelBar;
import com.moonlit.logfaces.client.widgets.OverviewTagBar;
import com.moonlit.logfaces.server.core.LogEvent;
import com.moonlit.logfaces.server.criteria.CriteriaFilter;
import com.moonlit.logfaces.server.remoting.LfsRemote;
import com.moonlit.logfaces.server.util.LfsEventBus;
import com.moonlit.logfaces.server.vo.LoggingEventVO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;

public class LogEditor
extends EditorPart
implements ISaveablePart2,
LogView,
Fontable,
LogEventListener,
LogModelListener,
IEclipsePreferences.IPreferenceChangeListener,
IPropertyChangeListener,
IPartListener {
    public static final String ID = "com.moonlit.logfaces.client.LogEditor";
    private Thread pollingThread;
    private boolean terminated;
    private Composite parent;
    private TableViewer viewer;
    private CLabel infoLabel;
    private Table table;
    private boolean scroll = true;
    private boolean trim = false;
    private boolean active = true;
    private LogEditorInput input;
    private Button resetFilterButton;
    private Button filtersButton;
    private Button scrollButton;
    private Button activationButton;
    private Button configButton;
    private Button exportButton;
    private LfsConnector connector = LfsConnector.getInstance();
    private ImageHolder images = ImageHolder.getInstance();
    private LogDataModel model = new Log4jModel();
    private LogViewFilter viewFilter = new LogViewFilterImpl();
    private OverviewBar overview;
    private OverviewTagBar tagview;
    private Shell shell;
    private Searchable searchAdapter;
    private ComponentsModel components = ComponentsModel.getInstance();
    private TagsModel tagsModel = TagsModel.getInstance();
    private LoggingEventVO lastSelected;
    private Map<Integer, Integer> colMap = Maps.newTreeMap();
    private SimpleDateFormat timeFormat;
    private SimpleDateFormat dateFormat;
    private String FONTID = "lfs.font.tables";
    private Font boldFont = Application.getFontRegistry().getBold(this.FONTID);
    private MyTableListener tableListener = new MyTableListener();
    private static final Logger log = LogManager.getLogger(LogEditor.class);

    @Override
    public LogDataModel getModel() {
        return this.model;
    }

    @Override
    public int getColumnType(int index) {
        for (int abs : this.colMap.keySet()) {
            if (this.colMap.get(abs) != index) continue;
            return abs;
        }
        return -1;
    }

    @Override
    public OverviewBar getLevelOverview() {
        return this.overview;
    }

    @Override
    public OverviewBar getTagsOverview() {
        return this.tagview;
    }

    @Override
    public TableViewer getTableViewer() {
        return this.viewer;
    }

    @Override
    public LogViewFilter getViewFilter() {
        return this.viewFilter;
    }

    @Override
    public void refresh(boolean deep) {
        this.table.setRedraw(false);
        this.table.removeAll();
        this.table.setRedraw(true);
        if (deep) {
            this.model.refresh();
        }
        this.updateView();
        this.retainSelection();
        Utils.packColumns(this);
    }

    @Override
    public LoggingEventVO getFilterEvent() {
        TableItem[] selected = this.table.getSelection();
        if (selected == null) {
            return null;
        }
        if (selected.length == 0) {
            return null;
        }
        return (LoggingEventVO)selected[0].getData();
    }

    @Override
    public TimeZone getTimeZone() {
        return this.input != null ? this.input.vo.getTimeZone() : TimeZone.getDefault();
    }

    @Override
    public Searchable getSearchable() {
        return this.searchAdapter;
    }

    @Override
    public QueryVO createPin() throws Exception {
        QueryVO query = new QueryVO();
        query.setLimit(-1);
        query.setPinID(UUID.randomUUID().toString());
        query.setName(this.input.getName());
        query.setHeaders(this.input.vo.getHeaders());
        query.setCriteria(this.getCriteria(true));
        ArrayList events = Lists.newArrayList();
        TableItem[] tableItemArray = this.table.getSelection();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            LogEvent event = (LogEvent)item.getData();
            events.add(event);
            query.addPinMark(event.getSequenceNumber());
            ++n2;
        }
        events.sort(new Comparator<LogEvent>(){

            @Override
            public int compare(LogEvent e1, LogEvent e2) {
                if (e1.getLoggerTimeStamp() - e2.getLoggerTimeStamp() > 0L) {
                    return 1;
                }
                if (e1.getLoggerTimeStamp() - e2.getLoggerTimeStamp() < 0L) {
                    return -1;
                }
                return 0;
            }
        });
        if (events.isEmpty()) {
            throw new Exception("nothing to pin");
        }
        int top = this.table.getTopIndex();
        int visible = this.table.getClientArea().height / this.table.getItemHeight();
        LogEvent e1 = (LogEvent)this.table.getItem(top).getData();
        LogEvent e2 = this.model.getStorageData().get(Math.min(top + visible - 1, this.model.getSize() - 1));
        query.setTimeRange(TimeRange.CUSTOM_RANGE, Math.min(e1.getLoggerTimeStamp(), ((LogEvent)events.get(0)).getLoggerTimeStamp()), Math.max(e2.getLoggerTimeStamp(), ((LogEvent)events.get(events.size() - 1)).getLoggerTimeStamp()));
        return query;
    }

    @Override
    public void modelUpdated(LogModelEvent change) {
        if (this.table == null || this.table.isDisposed()) {
            return;
        }
        switch (change) {
            case ANNOTATED: {
                this.viewer.setItemCount(this.model.getSize());
                this.table.clearAll();
                break;
            }
            case ADDED: {
                this.updateView();
                break;
            }
            case FILTERED: 
            case FINALIZED: {
                this.updateView();
                if (this.model.isEmpty()) break;
                Utils.packColumns(this);
                break;
            }
            case RETAG: {
                if (!this.colMap.containsKey(1)) break;
                List<Integer> lines = this.model.getTagLocations();
                TableItem[] items = this.table.getItems();
                int i = 0;
                while (i < items.length) {
                    int col = this.colMap.get(1);
                    LoggingEventVO event = (LoggingEventVO)items[i].getData();
                    if (lines.contains(i)) {
                        this.applyTagStyle(items[i], event);
                    } else if (!items[i].getText(col).isEmpty()) {
                        EventStyle style = this.model.getStyle((LogEvent)event);
                        items[i].setText(col, "");
                        items[i].setBackground(col, style.getBackground());
                        items[i].setForeground(col, style.getForeground());
                    }
                    ++i;
                }
                break;
            }
            case TRIMMED: {
                int remove = this.table.getItemCount() - this.model.getSize();
                if (remove <= 0) {
                    return;
                }
                int top = this.table.getTopIndex();
                try {
                    this.table.setRedraw(false);
                    this.table.remove(0, remove);
                    this.table.setRedraw(true);
                    if (this.scroll) break;
                    int newtop = top - remove - 1;
                    TableItem item = this.table.getItem(newtop >= 0 ? newtop : 0);
                    this.table.showItem(item);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                break;
            }
        }
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void updateActiveState() {
        if (this.table == null || this.table.isDisposed()) {
            return;
        }
        if (this.active == this.table.isVisible()) {
            return;
        }
        boolean previous = this.active;
        this.active = this.table.isVisible();
        if (this.active && previous != this.active) {
            this.updateView();
        }
    }

    private void updateView() {
        try {
            if (!this.active || this.infoLabel.isDisposed()) {
                return;
            }
            this.infoLabel.setText("" + this.model.getSize());
            this.viewer.setItemCount(this.model.getSize());
            if (this.scroll && this.table.getItemCount() > 0) {
                TableItem item = this.table.getItem(this.table.getItemCount() - 1);
                this.table.showItem(item);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void init(IEditorSite site, IEditorInput inp) throws PartInitException {
        LfsEventBus.getInstance().register((Object)this);
        this.input = (LogEditorInput)inp;
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(this.input);
        this.setPartName(this.input.getName());
        this.shell = site.getShell();
        this.timeFormat = this.input.vo.getTimeFormat();
        this.dateFormat = this.input.vo.getDateFormat();
        IPreferencesService prefs = Platform.getPreferencesService();
        this.trim = prefs.getBoolean("com.moonlit.logfaces.client.plugin", "lfs_perspective_trim", false, null);
        this.model.setAutoClear(prefs.getBoolean("com.moonlit.logfaces.client.plugin", "lfs_perspective_clear", false, null));
        this.model.setMaxSize(prefs.getInt("com.moonlit.logfaces.client.plugin", "lfs_perspective_size", 2000, null));
        this.model.addListener(this);
        log.info("starting perspective '{}'", (Object)this.input.getName());
        try {
            this.setTerminated(false);
            LfsRemote connection = this.connector.getConnection();
            if (connection == null) {
                throw new NotConnectedException();
            }
            if (connection instanceof LfsEmbeddedSession) {
                connection.setupPerspective(this.connector.getSid(), this.input.getName(), this.getCriteria(true));
                if (this.input.vo.isActivated()) {
                    connection.activatePerspective(this.connector.getSid(), this.input.getName());
                }
                ((LfsEmbeddedSession)connection).setListener(this.input.getName(), this);
            } else if (!prefs.getBoolean("com.moonlit.logfaces.client.plugin", "lfs_prefetch", true, null)) {
                this.activate(null);
            } else {
                new PerspectiveActivatorJob(this, this.getCriteria(true)).schedule();
            }
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
            throw new PartInitException(e.getMessage());
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        Application.getPrefs().addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        workbench.getThemeManager().addPropertyChangeListener((IPropertyChangeListener)this);
        workbench.getActiveWorkbenchWindow().getPartService().addPartListener((IPartListener)this);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellActivated(ShellEvent e) {
                Utils.updateActiveState(LogEditor.this);
            }

            public void shellDeactivated(ShellEvent e) {
                Utils.updateActiveState(LogEditor.this);
            }
        });
    }

    public void activate(List<LogEvent> events) {
        LfsRemote connection = this.connector.getConnection();
        if (connection == null) {
            return;
        }
        if (events != null) {
            this.model.addAll(events);
            this.updateView();
            Utils.packColumns(this);
        }
        if (this.input.vo.isActivated()) {
            this.activate(true);
        }
    }

    public boolean isDirty() {
        return true;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void setFocus() {
        if (this.table != null && !this.table.isDisposed()) {
            this.table.setFocus();
        }
    }

    public int promptToSaveOnClose() {
        this.setTerminated(true);
        return 0;
    }

    public void dispose() {
        log.info("closing perspective '{}'", (Object)this.input.getName());
        IWorkbench workbench = PlatformUI.getWorkbench();
        LfsEventBus.getInstance().unregister((Object)this);
        Application.getPrefs().removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        workbench.getThemeManager().removePropertyChangeListener((IPropertyChangeListener)this);
        workbench.getActiveWorkbenchWindow().getPartService().removePartListener((IPartListener)this);
        this.model.destroy();
        super.dispose();
        Display.getDefault().asyncExec(() -> this.disconnectFromServer());
    }

    private void createButtonBar() {
        Composite bar = new Composite(this.parent, this.parent.getStyle());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 11;
        gridLayout.horizontalSpacing = 0;
        bar.setLayout((Layout)gridLayout);
        GridData gd = new GridData(16384, 128, false, false);
        gd.widthHint = 90;
        this.activationButton = new Button(bar, 8);
        this.activationButton.setLayoutData((Object)gd);
        this.activationButton.setImage(this.images.getButtonImage("/icons/pause.gif"));
        this.activationButton.setToolTipText("Pause");
        if (this.input.vo.isActivated()) {
            this.activationButton.setImage(this.images.getButtonImage("/icons/pause.gif"));
            this.activationButton.setToolTipText("Pause");
            this.activationButton.setText("Pause");
        } else {
            this.activationButton.setImage(this.images.getButtonImage("/icons/play.gif"));
            this.activationButton.setToolTipText("Resume this perspective");
            this.activationButton.setText("Resume");
        }
        this.activationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogEditor.this.activate(!LogEditor.this.input.vo.isActivated());
            }
        });
        this.configButton = new Button(bar, 8);
        this.configButton.setImage(this.images.getButtonImage("/icons/preferences.gif"));
        this.configButton.setText("Modify");
        this.configButton.setLayoutData((Object)gd);
        this.configButton.setToolTipText("Modify perspective settings");
        this.configButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogPerspectiveDlg dialog = new LogPerspectiveDlg(LogEditor.this.getSite().getShell(), LogEditor.this.input.vo.clone());
                dialog.setRenameAllowed(false);
                dialog.open();
                if (dialog.getReturnCode() != 0) {
                    LogEditor.this.table.setFocus();
                    return;
                }
                LogEditor.this.input.setValueObject(dialog.getResult());
                Utils.parameterizeCriteria(LogEditor.this.input.rtCriteria);
                LogEditor.this.timeFormat = LogEditor.this.input.vo.getTimeFormat();
                LogEditor.this.dateFormat = LogEditor.this.input.vo.getDateFormat();
                LogPerspectivesModel myperspectives = LogPerspectivesModel.getInstance();
                if (myperspectives.getPerspective(LogEditor.this.input.vo.getName()) == null) {
                    if (MessageDialog.openQuestion((Shell)LogEditor.this.getSite().getShell(), (String)"Keep?", (String)"This perspective was created for temporal use.\nWould you like to keep it in your list?")) {
                        myperspectives.addPerspective(LogEditor.this.input.vo);
                    }
                } else {
                    myperspectives.addPerspective(LogEditor.this.input.vo);
                }
                try {
                    LfsRemote connection = LfsConnector.getInstance().getConnection();
                    if (connection == null) {
                        throw new NotConnectedException();
                    }
                    connection.setupPerspective(LogEditor.this.connector.getSid(), LogEditor.this.input.getName(), LogEditor.this.getCriteria(true));
                    LogEditor.this.applySettings();
                }
                catch (Exception ex) {
                    MessageDialog.openError(null, (String)"Operation failed", (String)ex.getMessage());
                }
                LogEditor.this.table.setFocus();
            }
        });
        Button button3 = new Button(bar, 8);
        button3.setImage(this.images.getButtonImage("icons/columns.gif"));
        button3.setText("Columns");
        button3.setLayoutData((Object)gd);
        button3.setToolTipText("Setup columns");
        button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (new ColumnsDlg(LogEditor.this.shell, LogEditor.this.input.vo.getHeaders()).open() == 0) {
                    LogEditor.this.layoutTable();
                    LogEditor.this.refresh(false);
                }
            }
        });
        Button button3a = new Button(bar, 8);
        button3a.setImage(this.images.getButtonImage("icons/alignwidth.gif"));
        button3a.setText("Pack");
        button3a.setLayoutData((Object)gd);
        button3a.setToolTipText("Arrange columns");
        button3a.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogEditor.this.packColumns();
            }
        });
        this.scrollButton = new Button(bar, 2);
        this.scrollButton.setText("Lock");
        this.scrollButton.setImage(this.images.getButtonImage("icons/lock.gif"));
        this.scrollButton.setLayoutData((Object)gd);
        this.scrollButton.setToolTipText("Scroll Lock");
        this.scrollButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogEditor.this.scroll = !LogEditor.this.scroll;
                LogEditor.this.table.setFocus();
            }
        });
        Button button5 = new Button(bar, 8);
        button5.setText("Clear");
        button5.setImage(this.images.getButtonImage("icons/eclipse3_clear.gif"));
        button5.setLayoutData((Object)gd);
        button5.setToolTipText("Clear view content");
        button5.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogEditor.this.clearContent();
                LogEditor.this.table.setFocus();
            }
        });
        this.exportButton = new Button(bar, 8);
        this.exportButton.setText("Send to");
        this.exportButton.setImage(this.images.getButtonImage("/icons/eclipse3_export.gif"));
        this.exportButton.setLayoutData((Object)gd);
        this.exportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogEditor.this.hookExportMenu();
            }
        });
        Button button8 = new Button(bar, 8);
        button8.setImage(this.images.getButtonImage("icons/feed.gif"));
        button8.setLayoutData((Object)gd);
        button8.setText("Find...");
        button8.setToolTipText("Find matching events (Ctrl+F)");
        button8.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindDialog.getInstance().activate(LogEditor.this.searchAdapter);
            }
        });
        this.resetFilterButton = new Button(bar, 8);
        this.resetFilterButton.setImage(this.images.getButtonImage("icons/eclipse3_view.gif"));
        this.resetFilterButton.setText("Clear filters");
        this.resetFilterButton.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.resetFilterButton.setToolTipText("Clear view filters");
        this.resetFilterButton.setVisible(false);
        this.resetFilterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogEditor.this.resetFilter();
                LogEditor.this.applyFilter(-1);
                LogEditor.this.resetFilterButton.setVisible(false);
                LogEditor.this.filtersButton.setVisible(false);
            }
        });
        this.filtersButton = new Button(bar, 8);
        this.filtersButton.setImage(this.images.getButtonImage("icons/dots.png"));
        this.filtersButton.setText("");
        this.filtersButton.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.filtersButton.setToolTipText("Manage applied filters");
        this.filtersButton.setVisible(false);
        this.filtersButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogEditor.this.adjustFilter();
            }
        });
        gd = new GridData(131072, 0x1000000, true, false);
        gd.widthHint = 50;
        this.infoLabel = new CLabel(bar, 131080);
        this.infoLabel.setLayoutData((Object)gd);
        bar.setLayoutData((Object)new GridData(4, 1, true, false, 3, 1));
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        parent.setLayout((Layout)gridLayout);
        this.createButtonBar();
        this.tagview = new OverviewTagBar(parent, this);
        GridData gd1 = new GridData();
        gd1.widthHint = 10;
        gd1.grabExcessVerticalSpace = true;
        gd1.verticalAlignment = 4;
        this.tagview.getControl().setLayoutData((Object)gd1);
        LogHeaderInfoVO[] headers = this.input.vo.getHeaders();
        if (headers.length != Columns.getNofColumns()) {
            headers = Columns.makeDefaultHeaders();
            this.input.vo.setHeaders(headers);
        }
        this.viewer = new TableViewer(parent, 268503810);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.table = this.viewer.getTable();
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.table.setFont(Application.getFontRegistry().get(this.FONTID));
        this.table.setData((Object)this.model);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        Utils.optimizeRowHeight(this.table);
        this.layoutTable();
        this.overview = new OverviewLevelBar(parent, this);
        GridData gd = new GridData();
        gd.widthHint = 10;
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 4;
        this.overview.getControl().setLayoutData((Object)gd);
        this.table.addMouseListener((MouseListener)new TableMouseAdapter());
        this.table.addListener(36, (Listener)this.tableListener);
        this.table.addListener(40, (Listener)new TableDrawListener());
        this.tagview.setView(this);
        this.overview.setView(this);
        this.searchAdapter = new SearchAdapter(this);
        this.hookContextMenu();
        Utils.displayOneTimeTip("tip_first_time_query", "You can apply view filters to this data set by clicking on certain column headers. This will refine the view even further. \n\nUse mouse right click within the table to obtain more options.\n\n(this message will not appear again)");
    }

    private void layoutTable() {
        this.table.setRedraw(false);
        while (this.table.getColumnCount() > 0) {
            this.table.getColumns()[0].dispose();
        }
        LogHeaderInfoVO[] headers = this.input.vo.getHeaders();
        TableLayout layout = new TableLayout();
        this.colMap.clear();
        int colNumber = 0;
        int i = 0;
        while (i < headers.length) {
            if (headers[i].isVisible()) {
                layout.addColumnData((ColumnLayoutData)new ColumnPixelData(headers[i].getWidth(), true));
                TableColumn col = new TableColumn(this.table, 16384);
                col.setText(headers[i].getName());
                col.setResizable(true);
                col.setWidth(headers[i].getWidth());
                col.setData((Object)i);
                if (i != 2 && i != 3 && i != 9 && i != 11) {
                    col.setToolTipText("click to set view filter");
                    col.addListener(13, (Listener)new HeaderColumnListener());
                }
                if (Columns.isMdcColumn(i)) {
                    col.setText(Columns.column2mdc(i));
                }
                this.colMap.put(i, colNumber++);
            }
            ++i;
        }
        if (this.colMap.containsKey(12)) {
            int mc = this.colMap.get(12);
            List<Integer> order = Utils.toList(this.table.getColumnOrder());
            order.remove((Object)mc);
            order.add(mc);
            this.table.setColumnOrder(Utils.toArray(order));
        }
        this.tagview.setShowTags(this.colMap.containsKey(1));
        this.tagview.modelUpdated(LogModelEvent.RETAG);
        this.table.setLayout((Layout)layout);
        this.table.setRedraw(true);
    }

    private TableColumn getColumn(int index) {
        try {
            TableColumn column = this.table.getColumn(this.colMap.get(index).intValue());
            return column;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void packColumns() {
        if (this.table.isDisposed()) {
            return;
        }
        this.table.setRedraw(false);
        int size = this.table.getColumnCount();
        int i = 0;
        while (i < size) {
            this.table.getColumn(i).pack();
            ++i;
        }
        this.table.setRedraw(true);
        this.table.setFocus();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("perspectivePopup");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                new ContextMenuBuilder(LogEditor.this, LogEditor.this.input.vo).build(manager);
                Utils.setContextVariable("headers", LogEditor.this.input.vo.getHeaders());
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void hookExportMenu() {
        MenuManager menuMgr = new MenuManager("exportPopup");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)new ExportToLogFileAction(LogEditor.this, LogEditor.this.input.getName(), FileFormat.pattern));
                manager.add((IAction)new ExportToLogFileAction(LogEditor.this, LogEditor.this.input.getName(), FileFormat.csv));
                manager.add((IAction)new ExportToLogFileAction(LogEditor.this, LogEditor.this.input.getName(), FileFormat.pattern, false, true));
            }
        });
        Point point = this.exportButton.getParent().toDisplay(this.exportButton.getLocation());
        point.y += this.exportButton.getSize().y;
        point.y += 2;
        Menu menu = menuMgr.createContextMenu((Control)this.exportButton);
        menu.setLocation(point);
        menu.setVisible(true);
    }

    private void applyTagStyle(TableItem item, LoggingEventVO event) {
        TagVO tag = this.tagsModel.findOne((LogEvent)event);
        if (tag != null) {
            int col = this.colMap.get(1);
            item.setText(col, (String)event.getProperties().get("tags"));
            item.setBackground(col, tag.getColor());
            item.setForeground(col, Utils.pickForeground(tag.getColor()));
        }
    }

    public void clearContent() {
        this.model.clear();
        this.viewFilter.reset();
        this.resetFilterButton.setVisible(false);
        this.infoLabel.setText(String.format("%d", this.model.getSize()));
        TableColumn[] tableColumnArray = this.table.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.setImage(null);
            ++n2;
        }
        this.getSite().getSelectionProvider().setSelection(null);
    }

    @Override
    public void handleLogEvent(LogEvent event) {
        this.model.addAndFilter(Lists.newArrayList((Object[])new LogEvent[]{event}), this.input.vo);
    }

    public void applySettings() {
        this.model.applyCriteria(this.input.vo.getCriteria());
        this.updateView();
    }

    private CriteriaFilter getCriteria(boolean parametrized) {
        return parametrized ? this.input.rtCriteria : this.input.vo.getCriteria();
    }

    private void resetFilter() {
        this.viewFilter.reset();
        this.resetFilterButton.setVisible(false);
        this.resetFilterButton.setVisible(false);
        TableColumn[] tableColumnArray = this.table.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.setImage(null);
            ++n2;
        }
    }

    private void adjustFilter() {
        ChoiceModel choice = new ChoiceModel();
        for (LogEventMatcher matcher : this.viewFilter.getMatchers()) {
            choice.addItem(matcher, matcher.isEnabled());
        }
        ListSelectionDialog dialog = new ListSelectionDialog("Check filters to enable", "icons/eclipse3_view.gif", choice);
        dialog.setFilter(false);
        if (dialog.open() != 0) {
            return;
        }
        ChoiceModelItem[] choiceModelItemArray = choice.getItems();
        int n = choiceModelItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ChoiceModelItem item = choiceModelItemArray[n2];
            LogEventMatcher matcher = (LogEventMatcher)item.getItem();
            matcher.setEnabled(item.isSelected());
            ++n2;
        }
        this.applyFilter(-1);
    }

    @Override
    public void applyFilter(int columnIndex) {
        this.model.setViewFilter(this.viewFilter);
        this.table.setRedraw(false);
        this.table.removeAll();
        this.table.setRedraw(true);
        this.resetFilterButton.setVisible(true);
        this.filtersButton.setVisible(this.viewFilter.getMatchers().size() > 1);
        try {
            TableColumn column = this.getColumn(columnIndex);
            if (column != null) {
                column.setImage(this.images.getImage("icons/eclipse3_view.gif"));
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.updateView();
        this.retainSelection();
        this.packColumns();
    }

    private void activate(final boolean activate) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                LfsRemote connection;
                block11: {
                    block10: {
                        if (LogEditor.this.isTerminated()) {
                            return;
                        }
                        LogEditor.this.activationButton.setEnabled(false);
                        connection = LfsConnector.getInstance().getConnection();
                        if (connection != null) break block10;
                        LogEditor.this.input.vo.setActivated(activate);
                        LogEditor.this.activationButton.setEnabled(connection != null);
                        LogEditor.this.activationButton.setImage(LogEditor.this.images.getButtonImage(activate ? "/icons/pause.gif" : "icons/run_exc.gif"));
                        LogEditor.this.activationButton.setToolTipText(activate ? "Pause this perspective" : "Resume this perspective");
                        LogEditor.this.activationButton.setText(activate ? "Pause" : "Resume");
                        LogEditor.this.table.setFocus();
                        return;
                    }
                    if (!activate) break block11;
                    if (LogEditor.this.pollingThread != null) {
                        LogEditor.this.pollingThread.interrupt();
                        LogEditor.this.pollingThread = null;
                    }
                    connection.setupPerspective(LogEditor.this.connector.getSid(), LogEditor.this.input.getName(), LogEditor.this.getCriteria(true));
                    connection.activatePerspective(LogEditor.this.connector.getSid(), LogEditor.this.input.getName());
                    LogEditor.this.pollingThread = new Thread(new PollingHandler());
                    LogEditor.this.pollingThread.start();
                    LogEditor.this.input.vo.setActivated(activate);
                    LogEditor.this.activationButton.setEnabled(connection != null);
                    LogEditor.this.activationButton.setImage(LogEditor.this.images.getButtonImage(activate ? "/icons/pause.gif" : "icons/run_exc.gif"));
                    LogEditor.this.activationButton.setToolTipText(activate ? "Pause this perspective" : "Resume this perspective");
                    LogEditor.this.activationButton.setText(activate ? "Pause" : "Resume");
                    LogEditor.this.table.setFocus();
                    return;
                }
                try {
                    try {
                        try {
                            connection.deactivatePerspective(LogEditor.this.connector.getSid(), LogEditor.this.input.getName());
                            LogEditor.this.pollingThread.interrupt();
                        }
                        catch (Exception exception) {}
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                        MessageDialog.openError(null, (String)"Error", (String)e.getMessage());
                        LogEditor.this.input.vo.setActivated(activate);
                        LogEditor.this.activationButton.setEnabled(connection != null);
                        LogEditor.this.activationButton.setImage(LogEditor.this.images.getButtonImage(activate ? "/icons/pause.gif" : "icons/run_exc.gif"));
                        LogEditor.this.activationButton.setToolTipText(activate ? "Pause this perspective" : "Resume this perspective");
                        LogEditor.this.activationButton.setText(activate ? "Pause" : "Resume");
                        LogEditor.this.table.setFocus();
                    }
                }
                catch (Throwable throwable) {
                    LogEditor.this.input.vo.setActivated(activate);
                    LogEditor.this.activationButton.setEnabled(connection != null);
                    LogEditor.this.activationButton.setImage(LogEditor.this.images.getButtonImage(activate ? "/icons/pause.gif" : "icons/run_exc.gif"));
                    LogEditor.this.activationButton.setToolTipText(activate ? "Pause this perspective" : "Resume this perspective");
                    LogEditor.this.activationButton.setText(activate ? "Pause" : "Resume");
                    LogEditor.this.table.setFocus();
                    throw throwable;
                }
                LogEditor.this.input.vo.setActivated(activate);
                LogEditor.this.activationButton.setEnabled(connection != null);
                LogEditor.this.activationButton.setImage(LogEditor.this.images.getButtonImage(activate ? "/icons/pause.gif" : "icons/run_exc.gif"));
                LogEditor.this.activationButton.setToolTipText(activate ? "Pause this perspective" : "Resume this perspective");
                LogEditor.this.activationButton.setText(activate ? "Pause" : "Resume");
                LogEditor.this.table.setFocus();
            }
        });
    }

    @Override
    public void disconnectFromServer() {
        if (this.isTerminated() && this.pollingThread == null) {
            return;
        }
        try {
            this.setTerminated(true);
            LfsRemote connection = LfsConnector.getInstance().getConnection();
            if (connection != null) {
                connection.removePerspective(this.connector.getSid(), this.input.getName());
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (this.pollingThread != null) {
            try {
                this.pollingThread.interrupt();
                this.pollingThread = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public void setTerminated(boolean terminated) {
        this.terminated = terminated;
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        String key = event.getKey();
        if ("lfs_perspective_trim".equals(key)) {
            this.trim = Application.getPrefs().getBoolean("lfs_perspective_trim", false);
        } else if ("lfs_perspective_clear".equals(key)) {
            this.model.setAutoClear(event.getNewValue() == null ? false : Boolean.parseBoolean(event.getNewValue().toString()));
            this.updateView();
        } else if ("lfs_perspective_size".equals(key)) {
            this.model.setMaxSize(Integer.parseInt(event.getNewValue().toString()));
            this.updateView();
        } else if ("lfs_levels".equals(key)) {
            this.refresh(true);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.FONTID.equals(event.getProperty())) {
            this.table.setFont(Application.getFontRegistry().get(this.FONTID));
            this.refresh(true);
            Utils.optimizeRowHeight(this.table);
        }
    }

    public void retainSelection() {
        int index = this.model.getIndexOf((LogEvent)this.lastSelected);
        if (index == -1) {
            return;
        }
        try {
            TableItem item = this.table.getItem(index);
            this.table.setSelection(index);
            this.table.showItem(item);
            this.table.setFocus();
            this.table.setTopIndex(index - 10);
            this.viewer.setSelection(this.viewer.getSelection());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void handleOverviewSelection(int index, int y) {
        try {
            int itemHeight = this.table.getItemHeight();
            int topIndex = y / itemHeight;
            this.table.setTopIndex(index - topIndex + 1);
            this.table.setSelection(index);
            this.table.setFocus();
            this.viewer.setSelection(this.viewer.getSelection());
            this.scrollButton.setSelection(true);
            this.scroll = false;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Subscribe
    public void handleLfcEvent(LfcEvent event) {
        if (this.isTerminated()) {
            return;
        }
        Display.getDefault().asyncExec(() -> {
            if (this.activationButton.isDisposed() || this.configButton.isDisposed()) {
                return;
            }
            if (event.is(LfcEvent.TYPE.CONNECTED)) {
                this.activationButton.setEnabled(true);
                this.configButton.setEnabled(true);
                this.activate(true);
            } else if (event.is(LfcEvent.TYPE.DISCONNECTED)) {
                this.activationButton.setEnabled(false);
                this.configButton.setEnabled(false);
                this.activate(false);
            } else if (event.is(LfcEvent.TYPE.GIS_SELECT)) {
                GisLocation location = (GisLocation)((Object)((Object)event.getContext()));
                int index = this.model.find(location.getIp(), 0, true);
                this.reveal(index);
            }
        });
    }

    public void reveal(int index) {
        if (index == -1) {
            return;
        }
        int topIndex = index - 5;
        this.table.setTopIndex(topIndex > 0 ? topIndex : 0);
        this.table.setSelection(index);
        this.viewer.setSelection(this.viewer.getSelection());
        this.scrollButton.setSelection(true);
        this.scroll = false;
    }

    @Override
    public String getFontID() {
        return this.FONTID;
    }

    public void partActivated(IWorkbenchPart part) {
        this.updateActiveState();
    }

    public void partDeactivated(IWorkbenchPart part) {
        this.updateActiveState();
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    class HeaderColumnListener
    implements Listener {
        HeaderColumnListener() {
        }

        public void handleEvent(Event event) {
            TableColumn column = (TableColumn)event.widget;
            int index = (Integer)column.getData();
            String filter = null;
            switch (index) {
                case 7: {
                    WildCardExpressionDialog dlg = new WildCardExpressionDialog(LogEditor.this.getSite().getShell(), "Loggers expression", "", LogEditor.this.model.getOptions(index));
                    if (dlg.open() == 1) {
                        return;
                    }
                    filter = dlg.getExpression();
                    if (!filter.equals("*")) break;
                    filter = null;
                    break;
                }
                case 10: {
                    ColumnFilterDlg dlg = new ColumnFilterDlg(LogEditor.this.getSite(), Lists.newArrayList((Object[])new String[]{"only thrown"}), false);
                    if (dlg.open() == 1) {
                        return;
                    }
                    filter = dlg.getOption();
                    break;
                }
                case 0: 
                case 12: {
                    ColumnFilterDlg dlg = new ColumnFilterDlg(LogEditor.this.getSite(), LogEditor.this.model.getOptions(index), index == 12);
                    if (dlg.open() == 1) {
                        return;
                    }
                    filter = dlg.getOption();
                    break;
                }
                default: {
                    ChoiceModel choice = new ChoiceModel(LogEditor.this.model.getOptions(index));
                    ListSelectionDialog dialog = new ListSelectionDialog("Check items to display", "icons/eclipse3_view.gif", choice);
                    if (dialog.open() != 0) {
                        return;
                    }
                    filter = choice.getSelectionAsRegex();
                }
            }
            LogEditor.this.viewFilter.setFocus(index, filter);
            LogEditor.this.applyFilter(index);
            LogEditor.this.resetFilterButton.setVisible(filter != null);
            if (filter == null) {
                column.setImage(null);
            }
        }
    }

    class MyTableListener
    implements Listener {
        MyTableListener() {
        }

        public void handleEvent(Annotation annotation) {
            TableItem item = LogEditor.this.table.getItem(annotation.getLocation());
            this.draw(item, annotation.getEvent());
        }

        public void handleEvent(Event e) {
            TableItem item = (TableItem)e.item;
            int index = LogEditor.this.table.indexOf(item);
            this.draw(item, LogEditor.this.model.getViewItem(index));
        }

        private void draw(TableItem item, LogEvent e) {
            TagVO tag;
            if (e == null | item == null) {
                return;
            }
            LoggingEventVO event = (LoggingEventVO)e;
            EventStyle style = LogEditor.this.model.getStyle((LogEvent)event);
            item.setData((Object)event);
            if (LogEditor.this.colMap.containsKey(0)) {
                item.setImage(LogEditor.this.colMap.get(0).intValue(), style.getImage());
            }
            item.setBackground(style.getBackground());
            item.setForeground(style.getForeground());
            if (style.isBold()) {
                item.setFont(LogEditor.this.boldFont);
            }
            Date date = new Date(event.getLoggerTimeStamp());
            if (LogEditor.this.colMap.containsKey(3)) {
                item.setText(LogEditor.this.colMap.get(3).intValue(), LogEditor.this.timeFormat.format(date));
            }
            if (LogEditor.this.colMap.containsKey(2)) {
                item.setText(LogEditor.this.colMap.get(2).intValue(), LogEditor.this.dateFormat.format(date));
            }
            if (LogEditor.this.colMap.containsKey(5)) {
                item.setText(LogEditor.this.colMap.get(5).intValue(), event.getDomainName());
            }
            if (LogEditor.this.colMap.containsKey(6)) {
                item.setText(LogEditor.this.colMap.get(6).intValue(), LogEditor.this.components.getComponent(event));
            }
            if (LogEditor.this.colMap.containsKey(4)) {
                item.setText(LogEditor.this.colMap.get(4).intValue(), event.getHostName());
            }
            if (LogEditor.this.colMap.containsKey(7)) {
                item.setText(LogEditor.this.colMap.get(7).intValue(), event.getLoggerNameShort());
            }
            if (LogEditor.this.colMap.containsKey(8)) {
                item.setText(LogEditor.this.colMap.get(8).intValue(), event.getThreadName());
            }
            if (LogEditor.this.colMap.containsKey(9)) {
                item.setText(LogEditor.this.colMap.get(9).intValue(), Utils.getLocationInfo((LogEvent)event));
            }
            if (event.isThrown() && LogEditor.this.colMap.containsKey(10)) {
                item.setText(LogEditor.this.colMap.get(10).intValue(), "( ! )");
            }
            if (LogEditor.this.colMap.containsKey(11)) {
                item.setText(LogEditor.this.colMap.get(11).intValue(), event.getNdc());
            }
            if (LogEditor.this.colMap.containsKey(12)) {
                String message = StringUtils.abbreviate((String)event.getMessage(), (int)259);
                String string = message = LogEditor.this.trim ? StringUtils.replaceChars((String)message, (String)"\r\n", (String)"") : message;
                if (StringUtils.isBlank((CharSequence)message) && event.isThrown()) {
                    message = Utils.getExceptionClass(event);
                    event.setMessage(message);
                }
                item.setText(LogEditor.this.colMap.get(12).intValue(), message);
            }
            for (String property : event.getProperties().keySet()) {
                int col;
                String value = event.getProperty(property);
                if (value == null || !LogEditor.this.colMap.containsKey(col = Columns.mdc2column(property))) continue;
                item.setText(LogEditor.this.colMap.get(col).intValue(), value);
            }
            if (LogEditor.this.colMap.containsKey(1) && (tag = LogEditor.this.tagsModel.findOne((LogEvent)event)) != null) {
                int col = LogEditor.this.colMap.get(1);
                item.setText(col, (String)event.getProperties().get("tags"));
                item.setBackground(col, tag.getColor());
                item.setForeground(col, Utils.pickForeground(tag.getColor()));
            }
        }
    }

    class PollingHandler
    implements Runnable {
        PollingHandler() {
        }

        @Override
        public void run() {
            boolean reconnect = false;
            LfsConnector connector = LfsConnector.getInstance();
            String sid = connector.getSid();
            String pname = LogEditor.this.input.getName();
            while (!LogEditor.this.isTerminated() && !Thread.currentThread().isInterrupted()) {
                try {
                    LfsRemote connection = connector.getConnection();
                    sid = connector.getSid();
                    if (connection == null || sid == null) {
                        Thread.sleep(3000L);
                        reconnect = true;
                        continue;
                    }
                    if (reconnect) {
                        connection.setupPerspective(sid, pname, LogEditor.this.getCriteria(true));
                        if (LogEditor.this.input.vo.isActivated()) {
                            connection.activatePerspective(sid, pname);
                        }
                        reconnect = false;
                    }
                    List events = connection.pollPerspective(sid, pname, LfsConnector.getInstance().getPollingTimeout());
                    if (Thread.currentThread().isInterrupted()) break;
                    LogEditor.this.model.addAndFilter(events, LogEditor.this.input.vo);
                }
                catch (InterruptedException e) {
                    break;
                }
                catch (Throwable e) {
                    connector.checkConnection();
                    reconnect = true;
                    log.warn(String.format("perspective %s is re-connecting, error: %s", pname, e.getMessage()));
                }
            }
            log.info("perspective '{}' thread ends", (Object)pname);
        }
    }

    class TableDrawListener
    implements Listener {
        TableDrawListener() {
        }

        public void handleEvent(Event event) {
            if (Util.isMac()) {
                Utils.overrideTableSelectionPaint(event, LogEditor.this.table);
                return;
            }
            if (!LogEditor.this.colMap.containsKey(1)) {
                return;
            }
            if (event.index != LogEditor.this.colMap.get(1)) {
                return;
            }
            TableColumn tc = LogEditor.this.getColumn(1);
            if (tc == null) {
                return;
            }
            TableItem item = (TableItem)event.item;
            if (item == null || item.isDisposed()) {
                return;
            }
            if (item.getText(event.index).isEmpty()) {
                return;
            }
            Rectangle rect = item.getBounds(event.index);
            event.gc.fillRectangle(rect);
        }
    }

    class TableMouseAdapter
    extends MouseAdapter {
        TableMouseAdapter() {
        }

        public void mouseDown(MouseEvent e) {
            if (LogEditor.this.table.getItemCount() == 0) {
                return;
            }
            TableItem[] selected = LogEditor.this.table.getSelection();
            if (selected == null || selected.length == 0) {
                return;
            }
            LogEditor.this.lastSelected = (LoggingEventVO)selected[0].getData();
        }

        public void mouseDoubleClick(MouseEvent e) {
            if (LogEditor.this.table.getItemCount() == 0) {
                return;
            }
            TableItem[] selected = LogEditor.this.table.getSelection();
            if (selected == null) {
                return;
            }
            if (selected.length != 1) {
                return;
            }
            LogEditor.this.lastSelected = (LoggingEventVO)selected[0].getData();
            if (LogEditor.this.lastSelected == null) {
                return;
            }
            new BrowseDetailsAction(LogEditor.this.lastSelected).run();
            LogEditor.this.getSite().getWorkbenchWindow().getActivePage().activate((IWorkbenchPart)LogEditor.this);
        }
    }
}

