/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.editors;

import com.google.common.collect.Sets;
import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.editors.DashboardEditor;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class DashboardPartManager
implements IPartListener {
    private static final Logger log = LogManager.getLogger(DashboardPartManager.class);
    private static DashboardPartManager instance;
    private IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    private Set<String> managedViews = Sets.newHashSet();
    private IWorkbenchPart lastActivePart;

    public static DashboardPartManager getInstance() {
        if (instance == null) {
            instance = new DashboardPartManager();
            DashboardPartManager.instance.window.getPartService().addPartListener((IPartListener)instance);
        }
        return instance;
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
        if (Application.isExiting() || !(part instanceof DashboardEditor)) {
            return;
        }
        if (this.lastActivePart != null && this.lastActivePart instanceof DashboardEditor) {
            return;
        }
        Display.getDefault().asyncExec(() -> {
            this.lastActivePart = part;
            IWorkbenchPage page = this.window.getActivePage();
            IViewReference[] views = page.getViewReferences();
            this.managedViews.clear();
            IViewReference[] iViewReferenceArray = views;
            int n = views.length;
            int n2 = 0;
            while (n2 < n) {
                IViewReference view = iViewReferenceArray[n2];
                page.hideView(view);
                this.managedViews.add(view.getId());
                ++n2;
            }
        });
    }

    public void partDeactivated(IWorkbenchPart part) {
        IWorkbenchPage page = this.window.getActivePage();
        this.lastActivePart = page.getActivePart();
        if (Application.isExiting() || !(part instanceof DashboardEditor)) {
            return;
        }
        if (this.lastActivePart != null && this.lastActivePart instanceof DashboardEditor) {
            return;
        }
        if (this.lastActivePart != null && this.lastActivePart instanceof ViewPart) {
            return;
        }
        Display.getDefault().asyncExec(() -> {
            if (Application.isExiting()) {
                return;
            }
            for (String vid : this.managedViews) {
                try {
                    page.showView(vid);
                }
                catch (PartInitException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        });
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }
}

