/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.editors;

import com.moonlit.logfaces.client.Application;
import com.moonlit.logfaces.client.ImageHolder;
import com.moonlit.logfaces.client.dashboard.Dashboard;
import com.moonlit.logfaces.client.dashboard.DashboardsModel;
import com.moonlit.logfaces.client.dashboard.WidgetDialog;
import com.moonlit.logfaces.client.dashboard.WidgetImpl;
import com.moonlit.logfaces.client.dialogs.DateTimeChooser;
import com.moonlit.logfaces.client.dialogs.DateTimeRangeChooser;
import com.moonlit.logfaces.client.editors.DashboardPartManager;
import com.moonlit.logfaces.client.model.EventStyles;
import com.moonlit.logfaces.client.types.Direction;
import com.moonlit.logfaces.client.types.TimeRange;
import com.moonlit.logfaces.server.criteria.EventAttribute;
import com.moonlit.logfaces.server.criteria.Operation;
import com.moonlit.logfaces.server.log4j.LfsLevel;
import com.novocode.ishell.DesktopForm;
import com.novocode.ishell.InternalShell;
import java.util.TimeZone;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DashboardEditor
extends EditorPart
implements ISaveablePart2 {
    public static final String ID = "com.moonlit.logfaces.client.editors.DashboardEditor";
    private Dashboard dashboard;
    private ComboViewer rangeTypeCombo;
    private DesktopForm desktop;
    private ImageHolder images = ImageHolder.getInstance();
    private static final Logger log = LogManager.getLogger(DashboardEditor.class);
    DashboardPartManager dpm = DashboardPartManager.getInstance();
    private Button leftButton;
    private Button rightButton;
    private Label infoLabel;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return true;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setFocus() {
    }

    public void dispose() {
        log.info("closing dashboard '{}'", (Object)this.getPartName());
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    public int promptToSaveOnClose() {
        this.dashboard.close();
        return 0;
    }

    public void init(IEditorSite site, IEditorInput inp) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(inp);
        this.setPartName(inp.getName());
        this.dashboard = DashboardsModel.getInstance().getDashboard(inp.getName());
        if (this.dashboard == null) {
            this.dashboard = DashboardsModel.getInstance().add(inp.getName());
        }
        log.info("opening dashboard '{}'", (Object)inp.getName());
    }

    public void createPartControl(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        parent.setLayout((Layout)gridLayout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        this.createButtonBar(parent);
        ScrolledComposite scrollable = new ScrolledComposite(parent, 768);
        scrollable.setExpandHorizontal(true);
        scrollable.setExpandVertical(true);
        scrollable.setLayoutData((Object)gd);
        scrollable.setBackground(EventStyles.BG_DRILL);
        this.desktop = new DesktopForm((Composite)scrollable, 2048);
        this.desktop.setShowMaximizedTitle(false);
        this.desktop.setAutoMaximize(false);
        this.desktop.setBackground(parent.getBackground());
        this.desktop.setLayoutData(gd);
        this.dashboard.display(this.desktop);
        this.updateInfoLabel();
        scrollable.setContent((Control)this.desktop);
        scrollable.setMinSize(this.desktop.computeSize(-1, -1));
    }

    private void createButtonBar(Composite parent) {
        Composite bar = new Composite(parent, parent.getStyle());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 9;
        gridLayout.horizontalSpacing = 0;
        bar.setLayout((Layout)gridLayout);
        bar.setLayoutData((Object)new GridData(4, 2, true, false, 1, 1));
        GridData buttonGd = new GridData(4, 4, false, false, 1, 1);
        buttonGd.verticalAlignment = 16;
        this.rangeTypeCombo = new ComboViewer(bar, 8);
        this.rangeTypeCombo.getCombo().setToolTipText("Time range for the query");
        this.rangeTypeCombo.getCombo().setLayoutData((Object)new GridData(4, 2, false, false, 1, 1));
        this.rangeTypeCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.rangeTypeCombo.setInput((Object)TimeRange.getRangesForDashboards());
        this.rangeTypeCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                TimeRange range = (TimeRange)((Object)element);
                return super.getText((Object)range.toDashboardLabel());
            }
        });
        this.rangeTypeCombo.setSelection((ISelection)new StructuredSelection((Object)this.dashboard.getRange()));
        this.rangeTypeCombo.getCombo().addSelectionListener((SelectionListener)new RangeTypeListener());
        Button button = new Button(bar, 8);
        button.setLayoutData((Object)buttonGd);
        button.setImage(this.images.getImage("icons/add.gif"));
        button.setText("Add new widget");
        button.setToolTipText("Add new widget to the dashboard");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DashboardEditor.this.addWidget();
            }
        });
        button = new Button(bar, 8);
        button.setLayoutData((Object)buttonGd);
        button.setImage(this.images.getImage("/icons/eclipse3_update.gif"));
        button.setText("Refresh all");
        button.setToolTipText("Force the updates of all widgets now");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DashboardEditor.this.dashboard.refresh();
                DashboardEditor.this.updateInfoLabel();
            }
        });
        button = new Button(bar, 8);
        button.setLayoutData((Object)buttonGd);
        button.setImage(this.images.getImage("icons/eclipse3_clear.gif"));
        button.setText("Remove all");
        button.setToolTipText("Remove all widgets from this dashboard");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!MessageDialog.openConfirm((Shell)Application.getShell(), (String)"Please confirm", (String)"Remove all widgets from this dashboard?")) {
                    return;
                }
                DashboardEditor.this.dashboard.clear();
            }
        });
        button = new Button(bar, 8);
        button.setLayoutData((Object)buttonGd);
        button.setImage(this.images.getImage("icons/eclipse3_edit.gif"));
        button.setText("Rename");
        button.setToolTipText("Rename this dashboard");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog input = new InputDialog(Application.getShell(), "Dashboard name", "New name:", DashboardEditor.this.dashboard.getName(), null);
                if (input.open() == 0) {
                    String value = input.getValue();
                    DashboardsModel.getInstance().rename(DashboardEditor.this.dashboard.getName(), value);
                    DashboardEditor.this.setPartName(value);
                }
            }
        });
        this.leftButton = new Button(bar, 8);
        this.leftButton.setImage(this.images.getButtonImage("/icons/e_back.gif"));
        this.leftButton.setText(Util.isMac() ? "<" : "");
        GridData gd = new GridData(16384, 0x1000000, false, false);
        gd.horizontalIndent = 10;
        this.leftButton.setLayoutData((Object)gd);
        this.leftButton.setToolTipText("Page backward");
        this.leftButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DashboardEditor.this.dashboard.page(Direction.backward);
                DashboardEditor.this.updateInfoLabel();
                DashboardEditor.this.rangeTypeCombo.getCombo().deselectAll();
            }
        });
        this.infoLabel = new Label(bar, 0);
        this.infoLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.rightButton = new Button(bar, 8);
        this.rightButton.setImage(this.images.getButtonImage("/icons/e_forward.gif"));
        this.rightButton.setText(Util.isMac() ? ">" : "");
        this.rightButton.setLayoutData((Object)gd);
        this.rightButton.setToolTipText("Page forward");
        this.rightButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DashboardEditor.this.dashboard.page(Direction.forward);
                DashboardEditor.this.updateInfoLabel();
                DashboardEditor.this.rangeTypeCombo.getCombo().deselectAll();
            }
        });
    }

    public void restore() {
        InternalShell shell = this.desktop.getActiveShell();
        if (shell != null) {
            shell.setMaximized(false);
        }
    }

    private void addWidget() {
        WidgetImpl widget = new WidgetImpl(this.dashboard);
        widget.getCriteria().addRule().addCondition((Object)EventAttribute.loggerLevel, (Object)Operation.emore, (Object)LfsLevel.WARN.name());
        widget.setName("New widget");
        WidgetDialog dialog = new WidgetDialog(this.getSite().getShell(), widget);
        if (dialog.open() == 0) {
            this.dashboard.add(widget);
            widget.open();
        }
    }

    private void updateInfoLabel() {
        TimeRange range = this.dashboard.getRange();
        DateTimeZone dtz = DateTimeZone.forTimeZone((TimeZone)TimeZone.getDefault());
        DateTimeFormatter dtf = DateTimeFormat.forPattern((String)"dd MMM HH:mm");
        this.infoLabel.setText(String.format(" %s - %s", dtf.withZone(dtz).print(range.getTime(true)), dtf.withZone(dtz).print(range.getTime(false))));
        this.infoLabel.requestLayout();
    }

    class RangeTypeListener
    implements SelectionListener {
        RangeTypeListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            TimeRange range = (TimeRange)((Object)((IStructuredSelection)DashboardEditor.this.rangeTypeCombo.getSelection()).getFirstElement());
            if (range == TimeRange.PARTICULAR_DAY) {
                DateTimeChooser dlg = new DateTimeChooser(DashboardEditor.this.getSite().getShell(), DashboardEditor.this.dashboard.getRange());
                dlg.setTimeVisible(false);
                if (dlg.open() != 0) {
                    return;
                }
                range.setCustomRange(dlg.getTime(), dlg.getTime() + 86400000L);
            } else if (range == TimeRange.CUSTOM_RANGE) {
                DateTimeRangeChooser dlg = new DateTimeRangeChooser(DashboardEditor.this.getSite().getShell(), DashboardEditor.this.dashboard.getRange());
                dlg.setTimeVisible(true);
                if (dlg.open() != 0) {
                    return;
                }
                range.setCustomRange(dlg.getTime(), dlg.getTime2());
            }
            DashboardEditor.this.dashboard.setRange(range);
            DashboardEditor.this.dashboard.refresh();
            DashboardEditor.this.updateInfoLabel();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

