/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.logfaces.client.dialogs;

import com.moonlit.logfaces.client.ImageHolder;
import java.util.Collection;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class WildCardExpressionDialog
extends Dialog {
    private String title;
    private Text expressionText;
    private Text filterText;
    private List list;
    private String expression;
    private Collection<String> options;

    public WildCardExpressionDialog(Shell parentShell, String title, String expression, Collection<String> options) {
        super(parentShell);
        this.setShellStyle(67696);
        this.title = title;
        this.expression = expression;
        this.options = options;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 64);
        label.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        label.setText("Specify wild card (*) matching expression:");
        this.expressionText = new Text(composite, 2048);
        this.expressionText.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.expressionText.setEnabled(true);
        this.expressionText.setBackground(new Color(null, 240, 255, 240));
        this.expressionText.setText(this.expression == null || this.expression.length() == 0 ? "*" : this.expression);
        Button clear = new Button(composite, 0);
        clear.setImage(ImageHolder.getInstance().getButtonImage("icons/eclipse3_clear.gif"));
        clear.setLayoutData((Object)new GridData(3, 2, false, false, 1, 1));
        clear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WildCardExpressionDialog.this.expressionText.setText("*");
            }
        });
        label = new Label(composite, 258);
        label.setLayoutData((Object)new GridData(4, 4, true, false, 2, 2));
        label = new Label(composite, 64);
        label.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        label.setText("Current items for your reference (select to grab):");
        this.list = new List(composite, 2820);
        this.list.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.list.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = WildCardExpressionDialog.this.list.getSelectionIndex();
                if (index != -1) {
                    WildCardExpressionDialog.this.expressionText.setText(WildCardExpressionDialog.this.list.getItem(index));
                }
            }
        });
        if (this.options != null) {
            for (String string : this.options) {
                this.list.add(string);
            }
        }
        this.filterText = new Text(composite, 2048);
        this.filterText.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.filterText.addKeyListener((KeyListener)new FilterListener());
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
        newShell.setImage(ImageHolder.getInstance().getImage("icons/class.gif"));
        Point point = Display.getCurrent().getCursorLocation();
        newShell.setSize(420, 480);
        newShell.setLocation(point.x, point.y);
    }

    protected void okPressed() {
        this.expression = this.expressionText.getText();
        if (this.expression == null || this.expression.length() == 0) {
            this.expression = "*";
        }
        super.okPressed();
    }

    public String getExpression() {
        return this.expression;
    }

    class FilterListener
    implements KeyListener {
        FilterListener() {
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
            if (WildCardExpressionDialog.this.options == null) {
                return;
            }
            String filter = WildCardExpressionDialog.this.filterText.getText();
            WildCardExpressionDialog.this.list.removeAll();
            for (String string : WildCardExpressionDialog.this.options) {
                if (!string.contains(filter)) continue;
                WildCardExpressionDialog.this.list.add(string);
            }
            WildCardExpressionDialog.this.list.redraw();
        }
    }
}

